/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.extractors;

import ai.platon.pulsar.boilerpipe.document.TextBlock;
import ai.platon.pulsar.boilerpipe.document.TextDocument;
import ai.platon.pulsar.boilerpipe.extractors.TextExtractor;
import ai.platon.pulsar.boilerpipe.filters.TextBlockFilter;
import ai.platon.pulsar.boilerpipe.utils.ProcessingException;
import java.util.List;
import java.util.ListIterator;

public class CanolaExtractor
implements TextExtractor {
    public static final CanolaExtractor INSTANCE = new CanolaExtractor();
    public static final TextBlockFilter CLASSIFIER = new TextBlockFilter(){

        @Override
        public boolean process(TextDocument doc) throws ProcessingException {
            List<TextBlock> textBlocks = doc.getTextBlocks();
            boolean hasChanges = false;
            ListIterator<TextBlock> it = textBlocks.listIterator();
            if (!it.hasNext()) {
                return false;
            }
            TextBlock prevBlock = TextBlock.EMPTY_START;
            TextBlock currentBlock = it.next();
            TextBlock nextBlock = it.hasNext() ? it.next() : TextBlock.EMPTY_START;
            hasChanges = this.classify(prevBlock, currentBlock, nextBlock) | hasChanges;
            if (nextBlock != TextBlock.EMPTY_START) {
                while (it.hasNext()) {
                    prevBlock = currentBlock;
                    currentBlock = nextBlock;
                    nextBlock = it.next();
                    hasChanges = this.classify(prevBlock, currentBlock, nextBlock) | hasChanges;
                }
                prevBlock = currentBlock;
                currentBlock = nextBlock;
                nextBlock = TextBlock.EMPTY_START;
                hasChanges = this.classify(prevBlock, currentBlock, nextBlock) | hasChanges;
            }
            return hasChanges;
        }

        protected boolean classify(TextBlock prev, TextBlock curr, TextBlock next) {
            boolean isContent = curr.getLinkDensity() > 0.0f && next.getNumWords() > 11 || curr.getNumWords() > 19 || next.getNumWords() > 6 && next.getLinkDensity() == 0.0f && prev.getLinkDensity() == 0.0f && (curr.getNumWords() > 6 || prev.getNumWords() > 7 || next.getNumWords() > 19);
            return curr.setIsContent(isContent);
        }
    };

    public static CanolaExtractor getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean process(TextDocument doc) throws ProcessingException {
        return CLASSIFIER.process(doc);
    }
}

