/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.extractors;

import ai.platon.pulsar.boilerpipe.document.TextDocument;
import ai.platon.pulsar.boilerpipe.filters.TextBlockFilter;
import ai.platon.pulsar.boilerpipe.sax.HTMLDownloader;
import ai.platon.pulsar.boilerpipe.sax.SAXInput;
import ai.platon.pulsar.boilerpipe.utils.ProcessingException;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import org.xml.sax.InputSource;

public interface TextExtractor
extends TextBlockFilter {
    default public String getText(String baseUrl, String html) throws ProcessingException {
        return this.getText(new SAXInput().parse(baseUrl, html));
    }

    default public String getText(String baseUrl, InputSource is) throws ProcessingException {
        return this.getText(new SAXInput().parse(baseUrl, is));
    }

    default public String getText(URL url) throws ProcessingException {
        try {
            return this.getText(url.toString(), HTMLDownloader.fetch(url));
        }
        catch (IOException e) {
            throw new ProcessingException(e);
        }
    }

    default public String getText(String baseUrl, Reader reader) throws ProcessingException {
        return this.getText(baseUrl, new InputSource(reader));
    }

    default public String getText(TextDocument doc) throws ProcessingException {
        this.process(doc);
        return doc.getTextContent();
    }
}

