/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.filters.heuristics;

import ai.platon.pulsar.boilerpipe.document.TextBlock;
import ai.platon.pulsar.boilerpipe.document.TextDocument;
import ai.platon.pulsar.boilerpipe.filters.TextBlockFilter;
import ai.platon.pulsar.boilerpipe.utils.ProcessingException;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public final class AddPrecedingLabelsFilter
implements TextBlockFilter {
    public static final AddPrecedingLabelsFilter INSTANCE = new AddPrecedingLabelsFilter("");
    public static final AddPrecedingLabelsFilter INSTANCE_PRE = new AddPrecedingLabelsFilter("^");
    private final String labelPrefix;

    public AddPrecedingLabelsFilter(String labelPrefix) {
        this.labelPrefix = labelPrefix;
    }

    @Override
    public boolean process(TextDocument doc) throws ProcessingException {
        List<TextBlock> textBlocks = doc.getTextBlocks();
        if (textBlocks.size() < 2) {
            return false;
        }
        boolean changes = false;
        int remaining = textBlocks.size();
        TextBlock blockBelow = null;
        ListIterator<TextBlock> it = textBlocks.listIterator(textBlocks.size());
        while (it.hasPrevious() && --remaining > 0) {
            if (blockBelow == null) {
                blockBelow = it.previous();
                continue;
            }
            TextBlock block = it.previous();
            Set<String> labels = block.getLabels();
            if (labels != null && !labels.isEmpty()) {
                for (String l : labels) {
                    blockBelow.addLabel(this.labelPrefix + l);
                }
                changes = true;
            }
            blockBelow = block;
        }
        return changes;
    }
}

