/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.filters.heuristics;

import ai.platon.pulsar.boilerpipe.document.TextBlock;
import ai.platon.pulsar.boilerpipe.document.TextDocument;
import ai.platon.pulsar.boilerpipe.filters.TextBlockFilter;
import ai.platon.pulsar.boilerpipe.utils.ProcessingException;

public class ContentDateStringNumberFilter
implements TextBlockFilter {
    public static final ContentDateStringNumberFilter INSTANCE = new ContentDateStringNumberFilter();

    public static ContentDateStringNumberFilter getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean process(TextDocument doc) throws ProcessingException {
        boolean hasChanges = false;
        if (doc.getDateTimeCount() >= 8 && !doc.getPageCategory().isDetail()) {
            for (TextBlock tb : doc.getTextBlocks()) {
                tb.addLabel("pulsar.text/TOO_MANY_DATE_STRING_CONTENT");
                tb.setIsContent(false);
                hasChanges = true;
            }
        }
        return hasChanges;
    }
}

