/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.filters.heuristics;

import ai.platon.pulsar.boilerpipe.document.TextBlock;
import ai.platon.pulsar.boilerpipe.document.TextDocument;
import ai.platon.pulsar.boilerpipe.filters.TextBlockFilter;
import ai.platon.pulsar.boilerpipe.utils.ProcessingException;
import java.util.List;
import java.util.ListIterator;

public final class ContentFusion
implements TextBlockFilter {
    public static final ContentFusion INSTANCE = new ContentFusion();

    @Override
    public boolean process(TextDocument doc) throws ProcessingException {
        List<TextBlock> textBlocks = doc.getTextBlocks();
        if (textBlocks.size() < 2) {
            return false;
        }
        TextBlock prevBlock = textBlocks.get(0);
        boolean changes = false;
        do {
            changes = false;
            ListIterator<TextBlock> it = textBlocks.listIterator(1);
            while (it.hasNext()) {
                TextBlock block = it.next();
                if (prevBlock.isContent() && (double)block.getLinkDensity() < 0.56 && !block.hasLabel("pulsar.text/STRICTLY_NOT_CONTENT")) {
                    prevBlock.mergeNext(block);
                    it.remove();
                    changes = true;
                    continue;
                }
                prevBlock = block;
            }
        } while (changes);
        return true;
    }
}

