/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.filters.heuristics;

import ai.platon.pulsar.boilerpipe.document.TextBlock;
import ai.platon.pulsar.boilerpipe.document.TextDocument;
import ai.platon.pulsar.boilerpipe.filters.TextBlockFilter;
import ai.platon.pulsar.boilerpipe.utils.ProcessingException;

public final class ExpandTitleToContentFilter
implements TextBlockFilter {
    public static final ExpandTitleToContentFilter INSTANCE = new ExpandTitleToContentFilter();

    public static ExpandTitleToContentFilter getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean process(TextDocument doc) throws ProcessingException {
        int i = 0;
        int title = -1;
        int contentStart = -1;
        for (TextBlock tb : doc.getTextBlocks()) {
            if (contentStart == -1 && tb.hasLabel("pulsar.text/CONTENT_TITLE")) {
                title = i;
                contentStart = -1;
            }
            if (contentStart == -1 && tb.isContent()) {
                contentStart = i;
            }
            ++i;
        }
        if (contentStart <= title || title == -1) {
            return false;
        }
        boolean changes = false;
        for (TextBlock tb : doc.getTextBlocks().subList(title, contentStart)) {
            if (!tb.hasLabel("pulsar.text/MIGHT_BE_CONTENT")) continue;
            changes = tb.setIsContent(true) | changes;
        }
        return changes;
    }
}

