/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.filters.heuristics;

import ai.platon.pulsar.boilerpipe.document.TextBlock;
import ai.platon.pulsar.boilerpipe.document.TextDocument;
import ai.platon.pulsar.boilerpipe.filters.TextBlockFilter;
import ai.platon.pulsar.boilerpipe.filters.heuristics.HeuristicFilterBase;
import ai.platon.pulsar.boilerpipe.utils.ProcessingException;
import java.util.List;
import java.util.ListIterator;

public final class IgnoreBlocksAfterContentFromEndFilter
extends HeuristicFilterBase
implements TextBlockFilter {
    public static final IgnoreBlocksAfterContentFromEndFilter INSTANCE = new IgnoreBlocksAfterContentFromEndFilter();

    private IgnoreBlocksAfterContentFromEndFilter() {
    }

    @Override
    public boolean process(TextDocument doc) throws ProcessingException {
        boolean changes = false;
        int words = 0;
        List<TextBlock> blocks = doc.getTextBlocks();
        if (!blocks.isEmpty()) {
            ListIterator<TextBlock> it = blocks.listIterator(blocks.size());
            while (it.hasPrevious()) {
                TextBlock tb = it.previous();
                if (tb.hasLabel("pulsar.text/INDICATES_END_OF_TEXT")) {
                    tb.addLabel("pulsar.text/STRICTLY_NOT_CONTENT");
                    tb.removeLabel("pulsar.text/MIGHT_BE_CONTENT");
                    tb.setIsContent(false);
                    changes = true;
                    continue;
                }
                if (!tb.isContent() || (words += tb.getNumWords()) <= 200) continue;
                break;
            }
        }
        return changes;
    }
}

