/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.filters.heuristics;

import ai.platon.pulsar.boilerpipe.document.TextBlock;
import ai.platon.pulsar.boilerpipe.document.TextDocument;
import ai.platon.pulsar.boilerpipe.filters.TextBlockFilter;
import ai.platon.pulsar.boilerpipe.filters.heuristics.HeuristicFilterBase;
import ai.platon.pulsar.boilerpipe.utils.ProcessingException;
import java.util.List;

public final class KeepLargestFulltextBlockFilter
extends HeuristicFilterBase
implements TextBlockFilter {
    public static final KeepLargestFulltextBlockFilter INSTANCE = new KeepLargestFulltextBlockFilter();

    @Override
    public boolean process(TextDocument doc) throws ProcessingException {
        List<TextBlock> textBlocks = doc.getTextBlocks();
        if (textBlocks.size() < 2) {
            return false;
        }
        int max = -1;
        TextBlock largestBlock = null;
        for (TextBlock tb : textBlocks) {
            int numWords;
            if (!tb.isContent() || (numWords = KeepLargestFulltextBlockFilter.getNumFullTextWords(tb)) <= max) continue;
            largestBlock = tb;
            max = numWords;
        }
        if (largestBlock == null) {
            return false;
        }
        for (TextBlock tb : textBlocks) {
            if (tb == largestBlock) {
                tb.setIsContent(true);
                continue;
            }
            tb.setIsContent(false);
            tb.addLabel("pulsar.text/MIGHT_BE_CONTENT");
        }
        return true;
    }
}

