/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.filters.heuristics;

import ai.platon.pulsar.boilerpipe.document.TextBlock;
import ai.platon.pulsar.boilerpipe.document.TextDocument;
import ai.platon.pulsar.boilerpipe.filters.TextBlockFilter;
import ai.platon.pulsar.boilerpipe.utils.ProcessingException;

public final class LargeBlockSameTagLevelToContentFilter
implements TextBlockFilter {
    public static final LargeBlockSameTagLevelToContentFilter INSTANCE = new LargeBlockSameTagLevelToContentFilter();

    private LargeBlockSameTagLevelToContentFilter() {
    }

    @Override
    public boolean process(TextDocument doc) throws ProcessingException {
        boolean changes = false;
        int tagLevel = -1;
        for (TextBlock tb : doc.getTextBlocks()) {
            if (!tb.isContent() || !tb.hasLabel("pulsar.text/VERY_LIKELY_CONTENT")) continue;
            tagLevel = tb.getTagLevel();
            break;
        }
        if (tagLevel == -1) {
            return false;
        }
        for (TextBlock tb : doc.getTextBlocks()) {
            if (tb.isContent() || tb.getNumWords() < 100 || tb.getTagLevel() != tagLevel) continue;
            tb.setIsContent(true);
            changes = true;
        }
        return changes;
    }
}

