/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.filters.heuristics;

import ai.platon.pulsar.boilerpipe.document.TextBlock;
import ai.platon.pulsar.boilerpipe.document.TextDocument;
import ai.platon.pulsar.boilerpipe.filters.TextBlockFilter;
import ai.platon.pulsar.boilerpipe.utils.ProcessingException;

public final class ListAtEndFilter
implements TextBlockFilter {
    public static final ListAtEndFilter INSTANCE = new ListAtEndFilter();

    private ListAtEndFilter() {
    }

    @Override
    public boolean process(TextDocument doc) throws ProcessingException {
        boolean changes = false;
        int tagLevel = Integer.MAX_VALUE;
        for (TextBlock tb : doc.getTextBlocks()) {
            if (tb.isContent() && tb.hasLabel("pulsar.text/VERY_LIKELY_CONTENT")) {
                tagLevel = tb.getTagLevel();
                continue;
            }
            if (tb.getTagLevel() > tagLevel && tb.hasLabel("pulsar.text/MIGHT_BE_CONTENT") && tb.hasLabel("pulsar.text/LI") && tb.getLinkDensity() == 0.0f) {
                tb.setIsContent(true);
                changes = true;
                continue;
            }
            tagLevel = Integer.MAX_VALUE;
        }
        return changes;
    }
}

