/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.filters.heuristics;

import ai.platon.pulsar.boilerpipe.document.TextBlock;
import ai.platon.pulsar.boilerpipe.document.TextDocument;
import ai.platon.pulsar.boilerpipe.filters.TextBlockFilter;
import ai.platon.pulsar.boilerpipe.utils.ProcessingException;
import java.util.List;
import java.util.ListIterator;

public class SimpleBlockFusionProcessor
implements TextBlockFilter {
    public static final SimpleBlockFusionProcessor INSTANCE = new SimpleBlockFusionProcessor();

    public static SimpleBlockFusionProcessor getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean process(TextDocument doc) throws ProcessingException {
        List<TextBlock> textBlocks = doc.getTextBlocks();
        boolean changes = false;
        if (textBlocks.size() < 2) {
            return false;
        }
        TextBlock b1 = textBlocks.get(0);
        ListIterator<TextBlock> it = textBlocks.listIterator(1);
        while (it.hasNext()) {
            boolean similar;
            TextBlock b2 = (TextBlock)it.next();
            boolean bl = similar = b1.getTextDensity() == b2.getTextDensity();
            if (similar) {
                b1.mergeNext(b2);
                it.remove();
                changes = true;
                continue;
            }
            b1 = b2;
        }
        return changes;
    }
}

