/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.filters.heuristics;

import ai.platon.pulsar.boilerpipe.document.TextBlock;
import ai.platon.pulsar.boilerpipe.document.TextDocument;
import ai.platon.pulsar.boilerpipe.filters.TextBlockFilter;
import ai.platon.pulsar.boilerpipe.utils.ProcessingException;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;

public class TerminatingBlocksFinder
implements TextBlockFilter {
    public static final TerminatingBlocksFinder INSTANCE = new TerminatingBlocksFinder();
    private final Set<String> contains = Sets.newTreeSet();
    private final Set<String> startsWith = Sets.newTreeSet();

    public static TerminatingBlocksFinder getInstance() {
        return INSTANCE;
    }

    public TerminatingBlocksFinder() {
    }

    public TerminatingBlocksFinder(Collection<String> contains, Collection<String> startsWith) {
        this.contains.addAll(contains);
        this.startsWith.addAll(startsWith);
    }

    @Override
    public boolean process(TextDocument doc) throws ProcessingException {
        boolean changes = false;
        for (TextBlock tb : doc.getTextBlocks()) {
            int numWords = tb.getNumWords();
            if (numWords >= 15) continue;
            String text = tb.getText().trim();
            int len = text.length();
            if (len >= 8) {
                String textLC = text.toLowerCase();
                boolean isTerminatingBlock = TerminatingBlocksFinder.startsWithNumber(textLC, len, " comments", " users responded in");
                if (!isTerminatingBlock) {
                    for (String str : this.contains) {
                        if (!textLC.contains(str.toLowerCase())) continue;
                        isTerminatingBlock = true;
                        break;
                    }
                }
                if (!isTerminatingBlock) {
                    for (String str : this.startsWith) {
                        if (!textLC.startsWith(str.toLowerCase())) continue;
                        isTerminatingBlock = true;
                        break;
                    }
                }
                if (!isTerminatingBlock) continue;
                tb.addLabel("pulsar.text/INDICATES_END_OF_TEXT");
                changes = true;
                continue;
            }
            if ((double)tb.getLinkDensity() != 1.0 || !text.equals("Comment")) continue;
            tb.addLabel("pulsar.text/INDICATES_END_OF_TEXT");
        }
        return changes;
    }

    private static boolean startsWithNumber(String t, int len, String ... str) {
        int j;
        for (j = 0; j < len && TerminatingBlocksFinder.isDigit(t.charAt(j)); ++j) {
        }
        if (j != 0) {
            for (String s : str) {
                if (!t.startsWith(s, j)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }
}

