/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.filters.simple;

import ai.platon.pulsar.boilerpipe.document.TextBlock;
import ai.platon.pulsar.boilerpipe.document.TextDocument;
import ai.platon.pulsar.boilerpipe.filters.TextBlockFilter;
import ai.platon.pulsar.boilerpipe.utils.ProcessingException;
import java.util.Iterator;
import java.util.List;

public final class BoilerplateBlockFilter
implements TextBlockFilter {
    public static final BoilerplateBlockFilter INSTANCE = new BoilerplateBlockFilter(null);
    public static final BoilerplateBlockFilter INSTANCE_KEEP_TITLE = new BoilerplateBlockFilter("pulsar.text/CONTENT_TITLE");
    private final String labelToKeep;

    public static BoilerplateBlockFilter getInstance() {
        return INSTANCE;
    }

    public BoilerplateBlockFilter(String labelToKeep) {
        this.labelToKeep = labelToKeep;
    }

    @Override
    public boolean process(TextDocument doc) throws ProcessingException {
        List<TextBlock> textBlocks = doc.getTextBlocks();
        boolean hasChanges = false;
        Iterator<TextBlock> it = textBlocks.iterator();
        while (it.hasNext()) {
            TextBlock tb = it.next();
            if (tb.isContent() || this.labelToKeep != null && tb.hasLabel("pulsar.text/CONTENT_TITLE") && tb.hasLabel("pulsar.text/CONTENT_TITLE")) continue;
            it.remove();
            hasChanges = true;
        }
        return hasChanges;
    }
}

