/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.filters.simple;

import ai.platon.pulsar.boilerpipe.document.TextBlock;
import ai.platon.pulsar.boilerpipe.document.TextDocument;
import ai.platon.pulsar.boilerpipe.filters.TextBlockFilter;
import ai.platon.pulsar.boilerpipe.utils.ProcessingException;
import ai.platon.pulsar.boilerpipe.utils.ScentUtils;
import com.google.common.collect.ListMultimap;
import java.util.Map;

public final class RegexFieldExtractorFilter
implements TextBlockFilter {
    private int keyGroup = 1;
    private int valueGroup = 2;
    private final int maxTextLength;
    private final ListMultimap<String, String> regexFieldRules;

    public RegexFieldExtractorFilter(ListMultimap<String, String> regexFieldRules, int maxTextLength) {
        this.regexFieldRules = regexFieldRules;
        this.maxTextLength = maxTextLength;
    }

    @Override
    public boolean process(TextDocument doc) throws ProcessingException {
        boolean changes = false;
        for (TextBlock tb : doc.getTextBlocks()) {
            if (!tb.isContent()) continue;
            String text = tb.getText();
            if (text.length() < this.maxTextLength) {
                changes = this.tryExtractText(doc, text);
                continue;
            }
            changes = this.tryExtractText(doc, text.substring(0, this.maxTextLength));
            changes |= this.tryExtractText(doc, text.substring(text.length() - this.maxTextLength, text.length()));
        }
        return changes;
    }

    private boolean tryExtractText(TextDocument doc, String text) {
        Map<String, String> results = ScentUtils.extract(text, this.regexFieldRules, this.keyGroup, this.valueGroup);
        results.forEach(doc::setField);
        return !results.isEmpty();
    }
}

