/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.filters.simple;

import ai.platon.pulsar.boilerpipe.document.TextBlock;
import ai.platon.pulsar.boilerpipe.document.TextDocument;
import ai.platon.pulsar.boilerpipe.filters.TextBlockFilter;
import ai.platon.pulsar.boilerpipe.utils.ProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class SplitParagraphBlocksFilter
implements TextBlockFilter {
    public static final SplitParagraphBlocksFilter INSTANCE = new SplitParagraphBlocksFilter();

    public static SplitParagraphBlocksFilter getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean process(TextDocument doc) throws ProcessingException {
        boolean changes = false;
        List<TextBlock> blocks = doc.getTextBlocks();
        ArrayList<TextBlock> blocksNew = new ArrayList<TextBlock>();
        for (TextBlock tb : blocks) {
            String text = tb.getText();
            String[] paragraphs = text.split("[\n\r]+");
            if (paragraphs.length < 2) {
                blocksNew.add(tb);
                continue;
            }
            boolean isContent = tb.isContent();
            Set<String> labels = tb.getLabels();
            for (String p : paragraphs) {
                TextBlock tbP = new TextBlock(p);
                tbP.setIsContent(isContent);
                tbP.addLabels(labels);
                blocksNew.add(tbP);
                changes = true;
            }
        }
        if (changes) {
            blocks.clear();
            blocks.addAll(blocksNew);
        }
        return changes;
    }
}

