/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.filters.statistics;

import ai.platon.pulsar.boilerpipe.document.TextBlock;
import ai.platon.pulsar.boilerpipe.document.TextDocument;
import ai.platon.pulsar.boilerpipe.filters.TextBlockFilter;
import ai.platon.pulsar.boilerpipe.filters.heuristics.HeuristicFilterBase;
import ai.platon.pulsar.boilerpipe.utils.ProcessingException;

public final class MinFulltextWordsFilter
extends HeuristicFilterBase
implements TextBlockFilter {
    public static final MinFulltextWordsFilter DEFAULT_INSTANCE = new MinFulltextWordsFilter(30);
    private final int minWords;

    public static MinFulltextWordsFilter getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public MinFulltextWordsFilter(int minWords) {
        this.minWords = minWords;
    }

    @Override
    public boolean process(TextDocument doc) throws ProcessingException {
        boolean changes = false;
        for (TextBlock tb : doc.getTextBlocks()) {
            if (!tb.isContent() || MinFulltextWordsFilter.getNumFullTextWords(tb) >= this.minWords) continue;
            tb.setIsContent(false);
            changes = true;
        }
        return changes;
    }
}

