/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.filters.statistics;

import ai.platon.pulsar.boilerpipe.document.TextBlock;
import ai.platon.pulsar.boilerpipe.document.TextDocument;
import ai.platon.pulsar.boilerpipe.filters.TextBlockFilter;
import ai.platon.pulsar.boilerpipe.utils.ProcessingException;
import java.util.List;
import java.util.ListIterator;

public class NumWordsRulesClassifier
implements TextBlockFilter {
    public static final NumWordsRulesClassifier INSTANCE = new NumWordsRulesClassifier();

    public static NumWordsRulesClassifier getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean process(TextDocument doc) throws ProcessingException {
        List<TextBlock> textBlocks = doc.getTextBlocks();
        boolean hasChanges = false;
        ListIterator<TextBlock> it = textBlocks.listIterator();
        if (!it.hasNext()) {
            return false;
        }
        TextBlock prevBlock = TextBlock.EMPTY_START;
        TextBlock currentBlock = it.next();
        TextBlock nextBlock = it.hasNext() ? it.next() : TextBlock.EMPTY_START;
        hasChanges = this.classify(prevBlock, currentBlock, nextBlock) | hasChanges;
        if (nextBlock != TextBlock.EMPTY_START) {
            while (it.hasNext()) {
                prevBlock = currentBlock;
                currentBlock = nextBlock;
                nextBlock = it.next();
                hasChanges = this.classify(prevBlock, currentBlock, nextBlock) | hasChanges;
            }
            prevBlock = currentBlock;
            currentBlock = nextBlock;
            nextBlock = TextBlock.EMPTY_START;
            hasChanges = this.classify(prevBlock, currentBlock, nextBlock) | hasChanges;
        }
        return hasChanges;
    }

    protected boolean classify(TextBlock prev, TextBlock curr, TextBlock next) {
        boolean isContent = (double)curr.getLinkDensity() <= 0.333333 ? ((double)prev.getLinkDensity() <= 0.555556 ? curr.getNumWords() > 16 || next.getNumWords() > 15 || prev.getNumWords() > 4 : curr.getNumWords() > 40 || next.getNumWords() > 17) : false;
        return curr.setIsContent(isContent);
    }
}

