/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.sax;

import ai.platon.pulsar.boilerpipe.document.LabelAction;
import ai.platon.pulsar.boilerpipe.sax.HTMLContentHandler;
import ai.platon.pulsar.boilerpipe.sax.TagAction;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class MarkupTagAction
implements TagAction {
    private final boolean isBlockLevel;
    private LinkedList<List<String>> labelStack = new LinkedList();
    private static final Pattern PAT_NUM = Pattern.compile("[0-9]+");

    public MarkupTagAction(boolean isBlockLevel) {
        this.isBlockLevel = isBlockLevel;
    }

    @Override
    public boolean start(HTMLContentHandler instance, String localName, String qName, Attributes atts) throws SAXException {
        String id;
        ArrayList<CallSite> labels = new ArrayList<CallSite>(5);
        labels.add((CallSite)((Object)("<" + localName)));
        String classVal = atts.getValue("class");
        if (classVal != null && classVal.length() > 0) {
            classVal = PAT_NUM.matcher(classVal).replaceAll("#");
            classVal = classVal.trim();
            String[] vals = classVal.split("[ ]+");
            labels.add((CallSite)((Object)("<." + classVal.replace(' ', '.'))));
            if (vals.length > 1) {
                for (String string : vals) {
                    labels.add((CallSite)((Object)("<." + string)));
                }
            }
        }
        if ((id = atts.getValue("id")) != null && id.length() > 0) {
            id = PAT_NUM.matcher(id).replaceAll("#");
            labels.add((CallSite)((Object)("<#" + id)));
        }
        Set<String> ancestors = this.getAncestorLabels();
        ArrayList<Object> labelsWithAncestors = new ArrayList<Object>((ancestors.size() + 1) * labels.size());
        for (String string : labels) {
            for (String an : ancestors) {
                labelsWithAncestors.add(an);
                labelsWithAncestors.add(an + " " + string);
            }
            labelsWithAncestors.add(string);
        }
        instance.addLabelAction(new LabelAction(labelsWithAncestors.toArray(new String[labelsWithAncestors.size()])));
        this.labelStack.add(labels);
        return this.isBlockLevel;
    }

    @Override
    public boolean end(HTMLContentHandler instance, String localName, String qName) throws SAXException {
        this.labelStack.removeLast();
        return this.isBlockLevel;
    }

    @Override
    public boolean changesTagLevel() {
        return this.isBlockLevel;
    }

    private Set<String> getAncestorLabels() {
        HashSet<String> set = new HashSet<String>();
        for (List list : this.labelStack) {
            if (list == null) continue;
            set.addAll(list);
        }
        return set;
    }
}

