/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.sax;

import ai.platon.pulsar.boilerpipe.document.TextDocument;
import ai.platon.pulsar.boilerpipe.sax.HTMLDownloader;
import ai.platon.pulsar.boilerpipe.sax.HTMLParser;
import ai.platon.pulsar.boilerpipe.utils.ProcessingException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SAXInput {
    public TextDocument parse(String baseUrl, InputSource is) throws ProcessingException {
        HTMLParser parser = new HTMLParser(baseUrl);
        try {
            parser.parse(is);
        }
        catch (IOException | SAXException e) {
            throw new ProcessingException(e);
        }
        return parser.getTextDocument();
    }

    public TextDocument parse(String baseUrl, String html) throws ProcessingException {
        return this.parse(baseUrl, new InputSource(new StringReader(html)));
    }

    public TextDocument parse(URL url) throws ProcessingException {
        try {
            return this.parse(url.toString(), HTMLDownloader.fetch(url));
        }
        catch (IOException e) {
            throw new ProcessingException(e);
        }
    }

    public TextDocument parse(String url) throws ProcessingException {
        try {
            String html = HTMLDownloader.fetch(url);
            return this.parse(url, html);
        }
        catch (IOException e) {
            throw new ProcessingException(e);
        }
    }

    public TextDocument parse(String baseUrl, Reader reader) throws ProcessingException {
        return this.parse(baseUrl, new InputSource(reader));
    }
}

