/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.utils;

import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public enum PageCategory {
    INDEX,
    DETAIL,
    SEARCH,
    MEDIA,
    BBS,
    TIEBA,
    BLOG,
    UNKNOWN;

    public static Pattern[] INDEX_PAGE_URL_PATTERNS;
    public static Pattern SEARCH_PAGE_URL_PATTERN;
    public static Pattern[] DETAIL_PAGE_URL_PATTERNS;
    public static Pattern MEDIA_PAGE_URL_PATTERN;
    public static final String[] MEDIA_URL_SUFFIXES;

    public boolean is(PageCategory pageCategory) {
        return pageCategory == this;
    }

    public boolean isIndex() {
        return this == INDEX;
    }

    public boolean isDetail() {
        return this == DETAIL;
    }

    public boolean isSearch() {
        return this == SEARCH;
    }

    public boolean isMedia() {
        return this == MEDIA;
    }

    public boolean isBBS() {
        return this == BBS;
    }

    public boolean isTieBa() {
        return this == TIEBA;
    }

    public boolean isBlog() {
        return this == BLOG;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public static PageCategory sniff(String url, int _char, int _a) {
        if (url.isEmpty()) {
            return UNKNOWN;
        }
        PageCategory pageCategory = PageCategory.sniff(url);
        if (pageCategory.isDetail()) {
            return pageCategory;
        }
        if (_char < 100) {
            if (_a > 30) {
                pageCategory = INDEX;
            }
        } else {
            return PageCategory.sniffByTextDensity(_char, _a);
        }
        return pageCategory;
    }

    private static PageCategory sniffByTextDensity(double _char, double _a) {
        PageCategory pageCategory = UNKNOWN;
        if (_a < 1.0) {
            _a = 1.0;
        }
        if (_a > 60.0 && _char / _a < 20.0) {
            pageCategory = INDEX;
        } else if (_char / _a > 30.0) {
            pageCategory = DETAIL;
        }
        return pageCategory;
    }

    public static PageCategory sniff(String urlString) {
        PageCategory pageCategory = UNKNOWN;
        if (StringUtils.isEmpty((CharSequence)urlString)) {
            return pageCategory;
        }
        String url = urlString.toLowerCase();
        if (url.endsWith("/")) {
            pageCategory = INDEX;
        } else if (StringUtils.countMatches((CharSequence)url, (CharSequence)"/") <= 3) {
            pageCategory = INDEX;
        } else if (Stream.of(INDEX_PAGE_URL_PATTERNS).anyMatch(pattern -> pattern.matcher(url).matches())) {
            pageCategory = INDEX;
        } else if (Stream.of(DETAIL_PAGE_URL_PATTERNS).anyMatch(pattern -> pattern.matcher(url).matches())) {
            pageCategory = DETAIL;
        } else if (SEARCH_PAGE_URL_PATTERN.matcher(url).matches()) {
            pageCategory = SEARCH;
        } else if (MEDIA_PAGE_URL_PATTERN.matcher(url).matches()) {
            pageCategory = MEDIA;
        }
        return pageCategory;
    }

    static {
        INDEX_PAGE_URL_PATTERNS = new Pattern[]{Pattern.compile(".+tieba.baidu.com/.+search.+"), Pattern.compile(".+(index|list|tags|chanel).+")};
        SEARCH_PAGE_URL_PATTERN = Pattern.compile(".+(search|query|select).+");
        DETAIL_PAGE_URL_PATTERNS = new Pattern[]{Pattern.compile(".+tieba.baidu.com/p/(\\d+)"), Pattern.compile(".+(detail|item|article|book|good|product|thread|view|post|content|/20[012][0-9]/{0,1}[01][0-9]/|/20[012]-[0-9]{0,1}-[01][0-9]/|/\\d{2,}/\\d{5,}|\\d{7,}).+")};
        MEDIA_PAGE_URL_PATTERN = Pattern.compile(".+(pic|picture|photo|avatar|photoshow|video).+");
        MEDIA_URL_SUFFIXES = new String[]{"js", "css", "jpg", "png", "jpeg", "gif"};
    }
}

