/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.boilerpipe.utils;

import ai.platon.pulsar.boilerpipe.utils.BoiConstants;
import com.google.common.collect.ListMultimap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ScentUtils {
    public static boolean checkFieldIsAPersonName(String fieldName) {
        return fieldName.equals("author") || fieldName.equals("director");
    }

    public static Map<String, String> extract(String text, ListMultimap<String, String> regexFieldRules) {
        return ScentUtils.extract(text, regexFieldRules, 1, 2);
    }

    public static Map<String, String> extract(String text, ListMultimap<String, String> regexFieldRules, int keyGroup, int valueGroup) {
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        for (Map.Entry rule : regexFieldRules.entries()) {
            String key;
            String value;
            String[] parts = ScentUtils.extractToArray(text, Pattern.compile((String)rule.getValue()), keyGroup, valueGroup);
            if (parts[0].length() <= 0 || parts[1].length() <= 0 || (value = ScentUtils.filterExtractedValue(key = (String)rule.getKey(), parts[1])) == null || value.isEmpty()) continue;
            if (ScentUtils.checkFieldIsAPersonName(key)) {
                if (Arrays.stream(BoiConstants.BAD_PHRASE_IN_NAME).anyMatch(value::contains)) {
                    value = null;
                }
            }
            if (value == null || value.isEmpty()) continue;
            Integer maxLength = BoiConstants.MAX_FIELD_LENGTH_MAP.get(key);
            if (maxLength == null) {
                results.put(key, value);
                continue;
            }
            if (value.length() > maxLength) continue;
            results.put(key, value);
        }
        return results;
    }

    private static String filterExtractedValue(String key, String value) {
        for (String bounder : BoiConstants.REGEX_FIELD_BOUNDERS) {
            if (!value.endsWith(bounder)) continue;
            value = StringUtils.substringBefore((String)value, (String)bounder);
            break;
        }
        return value;
    }

    public static String[] extractToArray(String text, Pattern pattern) {
        return ScentUtils.extractToArray(text, pattern, 1, 2);
    }

    public static String[] extractToArray(String text, Pattern pattern, int keyGroup, int valueGroup) {
        int groupCount;
        String[] parts = new String[]{"", ""};
        Matcher matcher = pattern.matcher(text);
        if (matcher.find() && keyGroup <= (groupCount = matcher.groupCount()) && valueGroup <= groupCount) {
            String k = matcher.group(keyGroup);
            String v = matcher.group(valueGroup);
            if (k != null && v != null) {
                parts[0] = k.trim();
                parts[1] = v.trim();
            }
        }
        return parts;
    }
}

