/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.examples;

import ai.platon.pulsar.context.PulsarContexts;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.session.PulsarSession;
import com.google.gson.Gson;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BasicUsage {
    public static void main(String[] args) {
        PulsarSession session = PulsarContexts.createSession();
        String url = "https://list.jd.com/list.html?cat=652,12345,12349";
        WebPage page = session.load(url, "-expires 1d");
        FeaturedDocument document = session.parse(page, false);
        FeaturedDocument document2 = session.loadDocument(url, "-expires 1d");
        List pages = session.loadOutPages(url, "-expires 1d -itemExpires 7d -outLink a[href~=item]");
        List fields = session.scrape(url, "-expires 1d", "li[data-sku]", Arrays.asList(".p-name em", ".p-price"));
        List fields2 = session.scrape(url, "-i 1d", "li[data-sku]", Map.of("name", ".p-name em", "price", ".p-price"));
        System.out.println("== document");
        System.out.println(document.getTitle());
        System.out.println(document.selectFirst("title").text());
        System.out.println("== document2");
        System.out.println(document2.getTitle());
        System.out.println(document2.selectFirst("title").text());
        System.out.println("== pages");
        System.out.println(pages.stream().map(WebPage::getUrl).collect(Collectors.toList()));
        Gson gson = new Gson();
        System.out.println("== fields");
        System.out.println(gson.toJson((Object)fields));
        System.out.println("== fields2");
        System.out.println(gson.toJson((Object)fields2));
    }
}

