/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.examples.sites.fashion.saxx;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.sql.SQLTemplate;
import ai.platon.pulsar.test.ProductExtractor;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\b\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u00a8\u0006\u0002"}, d2={"main", "", "pulsar-examples"})
public final class SaxxCrawlerKt {
    public static final void main() {
        String[] itemUrls;
        String indexSQL = "\n        select\n           dom_attr(dom, 'data-name') as `title`,\n           dom_attr(dom, 'data-variant-price') as `list_Price`,\n           dom_attr(dom, 'data-price') as `price`,\n           dom_first_attr(dom, 'div.product-item__swatch-list', 'data-swatch-count') as `variant_Count`,\n           dom_first_attr(dom, 'a[data-product-link] div[title~=star]', 'title') as `rating_Text`,\n           str_substring_before(dom_first_attr(dom, 'a[data-product-link] div[title~=star]', 'title'), ' star') as `rating`,\n           str_substring_between(dom_first_attr(dom, 'a[data-product-link] div[title~=star]', 'title'), 'with ', ' reviews') as `reviews`,\n           dom_first_href(dom, 'a[data-product-link]') as `product_Link`,\n           dom_base_uri(dom) as `base_Uri`\n        from\n           load_and_select(\n                'https://www.saxxunderwear.com/collections/underwear \n                    -i 1d -requireSize 500000 -netCond worse',\n                'div.collection-list > .collection-list-row div.product-card'\n           )\n        ";
        String itemsSQLTemplate = "\n        select\n           dom_first_text(dom, 'h1.title') as `name`,\n           dom_first_text(dom, '.price-preview del[data-product-id]') as `list_Price`,\n           dom_first_text(dom, '.price-preview span[data-product-id]') as `price`,\n           dom_first_text(dom, 'div.bottom-line-items span:contains(star rating)') as `rating`,\n           dom_first_text(dom, 'span.reviews-qa-label') as `reviews`,\n\n           dom_all_texts(dom, '.product-options.has-options .swatch.size label') as `color_Variants`,\n\n           dom_first_text(dom, '.product-description') as `description`,\n\n           dom_first_attr(dom, 'div.product-gallery div[data-zoom-img]', 'data-zoom-img') as `big_Images`,\n           dom_base_uri(dom) as `baseUri`\n        from\n           load_out_pages(\n                '{{url}}\n                    -i 1s -ii 1s -requireSize 500000 -itemRequireSize 300000 -ignoreFailure -netCond worst -topLinks 20',\n                'div.product-card a[href~=/products/]'\n           )\n        ";
        String reviewsSQLTemplate = "\n        select\n           dom_first_text(dom, '.yotpo-user-name') as `user_Name`,\n           dom_first_text(dom, '.yotpo-review-date') as `date`,\n           dom_first_text(dom, '.yotpo-user-field:contains(Fit)') as `fit`,\n           dom_first_text(dom, '.yotpo-user-title') as `user_Type`,\n\n           dom_first_text(dom, 'div.yotpo-review-stars span:contains(rating)') as `rating`,\n           dom_first_text(dom, '.yotpo-main .content-title') as `title`,\n           dom_first_text(dom, '.content-review') as `content`,\n           dom_base_uri(dom) as `baseUri`\n        from\n           load_and_select(\n                '{{url}} -i 1d -netCond worse',\n                '.yotpo-reviews .yotpo-review'\n           )\n        ";
        String now = DateTimes.INSTANCE.formatNow("HH");
        Path path = AppPaths.INSTANCE.getTmp("rs", new String[0]).resolve(now).resolve("saxx");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        ProductExtractor executor = new ProductExtractor(path, null, 2, null);
        String[] stringArray = new String[]{"https://www.saxxunderwear.com/collections/underwear"};
        String[] $this$forEach$iv = itemUrls = stringArray;
        boolean $i$f$forEach = false;
        String[] stringArray2 = $this$forEach$iv;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String url = element$iv = stringArray2[i];
            boolean bl = false;
            String itemsSQL = new SQLTemplate(itemsSQLTemplate, null, 2, null).createInstance(url).getSql();
            executor.extract(itemsSQL, reviewsSQLTemplate);
        }
        executor.getContext().await();
    }

    public static /* synthetic */ void main(String[] args) {
        SaxxCrawlerKt.main();
    }
}

