/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.examples.sites.fashion.tommyjohn;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.sql.SQLTemplate;
import ai.platon.pulsar.ql.context.SQLContext;
import ai.platon.pulsar.ql.context.SQLContextsKt;
import ai.platon.pulsar.test.ProductExtractor;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\b\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u00a8\u0006\u0002"}, d2={"main", "", "pulsar-examples"})
public final class TommyCrawlerKt {
    public static final void main() {
        String indexSQL = "\n        select\n           dom_attr(dom, 'data-name') as `title`,\n           dom_attr(dom, 'data-variant-price') as `list_Price`,\n           dom_attr(dom, 'data-price') as `price`,\n           dom_first_attr(dom, 'div.product-item__swatch-list', 'data-swatch-count') as `variant_Count`,\n           dom_first_attr(dom, 'a[data-product-link] div[title~=star]', 'title') as `rating_Text`,\n           str_substring_before(dom_first_attr(dom, 'a[data-product-link] div[title~=star]', 'title'), ' star') as `rating`,\n           str_substring_between(dom_first_attr(dom, 'a[data-product-link] div[title~=star]', 'title'), 'with ', ' reviews') as `reviews`,\n           dom_first_href(dom, 'a[data-product-link]') as `product_Link`,\n           dom_base_uri(dom) as `base_Uri`\n        from\n           load_and_select(\n                'https://tommyjohn.com/collections/loungewear-mens?sort-by=relevance&sort-order=descending\n                    -i 1d -requireSize 500000 -netCond worse',\n                'div[data-collection-entry] > div[data-product-id]'\n           )\n        ";
        String itemsSQLTemplate = "\n        select\n           dom_first_text(dom, 'section.product-main h1.product-info__title') as `name`,\n           dom_first_text(dom, 'section.product-main span.product-info__price') as `price`,\n           dom_first_text(dom, 'section.product-main .yotpo-stars span:contains(star rating)') as `rating`,\n           str_substring_between(dom_first_text(dom, 'section.product-main .yotpo-stars ~ a'), '(', ')') as `reviews`,\n\n           dom_all_attrs(dom, 'div[data-color-section=Color] ul li input', 'value') as `color_Variants`,\n           dom_all_texts(dom, 'div[data-option-name=Size] ul li') as `size_Variants`,\n\n           dom_first_text(dom, 'div.product-details-container section[data-product-details-description]') as `product_Details`,\n           dom_first_text(dom, 'div.product-page__options .product-description') as `description`,\n\n           dom_first_attr(dom, 'div.product-gallery div[data-zoom-img]', 'data-zoom-img') as `big_Images`,\n           dom_base_uri(dom) as `baseUri`\n        from\n           load_out_pages(\n                '{{url}}\n                    -i 1d -requireSize 500000 -itemRequireSize 250000 -ignoreFailure -netCond worst',\n                'div.product-item a.product-meta:has(span.product-meta__title)'\n           )\n        ";
        String reviewsSQLTemplate = "\n        select\n           dom_first_text(dom, 'p.reviewer-user-name') as `user_Name`,\n           dom_first_text(dom, 'p.yotpo-review-buyer-data:contains(Date)') as `date`,\n           dom_first_text(dom, 'p.yotpo-review-buyer-data:contains(Fit)') as `fit`,\n           dom_first_text(dom, 'p.reviewer-user-type') as `user_Type`,\n\n           dom_first_text(dom, 'span.yotpo-review-stars span:contains(rating)') as `rating`,\n           dom_first_text(dom, 'p.yotpo-review-title') as `title`,\n           dom_first_text(dom, 'div.yotpo-review-content') as `content`,\n           dom_base_uri(dom) as `baseUri`\n        from\n           load_and_select(\n                '{{url}} -i 1d -netCond worse',\n                'ul.review-list li.review-item'\n           )\n        ";
        SQLContextsKt.withSQLContext((Function1)((Function1)new Function1<SQLContext, Unit>(itemsSQLTemplate, reviewsSQLTemplate){
            final /* synthetic */ String $itemsSQLTemplate;
            final /* synthetic */ String $reviewsSQLTemplate;
            {
                this.$itemsSQLTemplate = $itemsSQLTemplate;
                this.$reviewsSQLTemplate = $reviewsSQLTemplate;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull SQLContext ctx) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                String now = DateTimes.INSTANCE.formatNow("HH");
                Path path = AppPaths.INSTANCE.getTmp("rs", new String[0]).resolve(now).resolve("tommy");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                ProductExtractor executor = new ProductExtractor(path, ctx);
                Object object = new String[]{"https://tommyjohn.com/collections/loungewear-mens?sort-by=relevance&sort-order=descending", "https://tommyjohn.com/collections/mens-socks?sort-by=relevance&sort-order=descending", "https://tommyjohn.com/collections/mens-undershirts?sort-by=relevance&sort-order=descending", "https://tommyjohn.com/collections/mens-underwear-all-styles"};
                Object[] itemUrls = object;
                object = ArraysKt.take((Object[])itemUrls, (int)1);
                String string = this.$itemsSQLTemplate;
                String string2 = this.$reviewsSQLTemplate;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String url = (String)element$iv;
                    boolean bl = false;
                    String itemsSQL = new SQLTemplate(string, null, 2, null).createInstance(url).getSql();
                    executor.extract(itemsSQL, string2);
                }
            }
        }));
    }

    public static /* synthetic */ void main(String[] args) {
        TommyCrawlerKt.main();
    }
}

