/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.examples.sites.spa.wemix;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.options.LoadOptions;
import ai.platon.pulsar.crawl.WebPageWebDriverHandler;
import ai.platon.pulsar.examples.sites.spa.wemix.AjaxFetchHandler;
import ai.platon.pulsar.session.PulsarSession;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0016\u001a\u00020\u0017R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lai/platon/pulsar/examples/sites/spa/wemix/AjaxCrawler;", "", "initPageNumber", "", "session", "Lai/platon/pulsar/session/PulsarSession;", "(ILai/platon/pulsar/session/PulsarSession;)V", "getInitPageNumber", "()I", "setInitPageNumber", "(I)V", "logger", "Lorg/slf4j/Logger;", "reportDirectory", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getReportDirectory", "()Ljava/nio/file/Path;", "getSession", "()Lai/platon/pulsar/session/PulsarSession;", "url", "", "crawl", "", "pulsar-examples"})
final class AjaxCrawler {
    private int initPageNumber;
    @NotNull
    private final PulsarSession session;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String url;
    private final Path reportDirectory;

    public AjaxCrawler(int initPageNumber, @NotNull PulsarSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.initPageNumber = initPageNumber;
        this.session = session;
        this.logger = LogsKt.getLogger((Object)this);
        this.url = "https://scope.wemixnetwork.com/1003/token/0xcb7615cb4322cddc518f670b4da042dbefc69500";
        this.reportDirectory = AppPaths.INSTANCE.getREPORT_DIR().resolve("wemix").resolve("b" + this.initPageNumber);
    }

    public /* synthetic */ AjaxCrawler(int n, PulsarSession pulsarSession, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        this(n, pulsarSession);
    }

    public final int getInitPageNumber() {
        return this.initPageNumber;
    }

    public final void setInitPageNumber(int n) {
        this.initPageNumber = n;
    }

    @NotNull
    public final PulsarSession getSession() {
        return this.session;
    }

    public final Path getReportDirectory() {
        return this.reportDirectory;
    }

    public final void crawl() {
        if (Files.exists(this.reportDirectory, new LinkOption[0])) {
            return;
        }
        Path path = this.reportDirectory;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"reportDirectory");
        AjaxFetchHandler apiFetcherHandler = new AjaxFetchHandler(this.initPageNumber, path);
        LoadOptions options = PulsarSession.DefaultImpls.options$default((PulsarSession)this.session, (String)"-refresh", null, (int)2, null);
        options.ensureEventHandler().getSimulateEventHandler().getOnBeforeComputeFeature().addLast((WebPageWebDriverHandler)apiFetcherHandler);
        try {
            this.session.load(this.url, options);
        }
        catch (Exception e) {
            this.logger.warn("Unexpected exception", (Throwable)e);
        }
    }
}

