/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.parse.tika;

import ai.platon.pulsar.parse.tika.XMLCharacterRecognizer;
import java.io.Writer;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0006H\u0004J\u001e\u00102\u001a\u0002002\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000206J \u00108\u001a\u0002002\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000206H\u0016J\u001e\u00109\u001a\u0002002\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000206J \u0010:\u001a\u0002002\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000206H\u0016J\b\u0010;\u001a\u000200H\u0016J\b\u0010<\u001a\u000200H\u0016J\b\u0010=\u001a\u000200H\u0016J \u0010>\u001a\u0002002\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020@2\u0006\u0010B\u001a\u00020@H\u0016J\u0010\u0010C\u001a\u0002002\u0006\u0010B\u001a\u00020@H\u0016J\u0010\u0010D\u001a\u0002002\u0006\u0010E\u001a\u00020@H\u0016J\u0010\u0010F\u001a\u0002002\b\u0010B\u001a\u0004\u0018\u00010@J \u0010G\u001a\u0002002\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000206H\u0016J\u0018\u0010H\u001a\u0002002\u0006\u0010I\u001a\u00020@2\u0006\u0010J\u001a\u00020@H\u0016J\u0010\u0010K\u001a\u0002002\u0006\u0010L\u001a\u00020MH\u0016J\u001a\u0010N\u001a\u0002002\b\u0010O\u001a\u0004\u0018\u00010@2\b\u0010P\u001a\u0004\u0018\u00010 J\u0010\u0010Q\u001a\u0002002\u0006\u0010B\u001a\u00020@H\u0016J\b\u0010R\u001a\u000200H\u0016J \u0010S\u001a\u0002002\u0006\u0010B\u001a\u00020@2\u0006\u0010T\u001a\u00020@2\u0006\u0010U\u001a\u00020@H\u0016J\b\u0010V\u001a\u000200H\u0016J(\u0010W\u001a\u0002002\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020@2\u0006\u0010B\u001a\u00020@2\u0006\u0010X\u001a\u00020YH\u0016J\u0010\u0010Z\u001a\u0002002\u0006\u0010B\u001a\u00020@H\u0016J\u0018\u0010[\u001a\u0002002\u0006\u0010E\u001a\u00020@2\u0006\u0010\\\u001a\u00020@H\u0016R(\u0010\r\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0006@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u000bR\u001c\u0010\u0019\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0014\"\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000fR\u0013\u0010+\u001a\u0004\u0018\u00010,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u0006]"}, d2={"Lai/platon/pulsar/parse/tika/DOMBuilder;", "Lorg/xml/sax/ContentHandler;", "Lorg/xml/sax/ext/LexicalHandler;", "doc", "Lorg/w3c/dom/Document;", "node", "Lorg/w3c/dom/Node;", "(Lorg/w3c/dom/Document;Lorg/w3c/dom/Node;)V", "docFrag", "Lorg/w3c/dom/DocumentFragment;", "(Lorg/w3c/dom/Document;Lorg/w3c/dom/DocumentFragment;)V", "(Lorg/w3c/dom/Document;)V", "<set-?>", "currentNode", "getCurrentNode", "()Lorg/w3c/dom/Node;", "setCurrentNode", "(Lorg/w3c/dom/Node;)V", "isOutsideDocElem", "", "()Z", "m_doc", "getM_doc", "()Lorg/w3c/dom/Document;", "setM_doc", "m_docFrag", "getM_docFrag", "()Lorg/w3c/dom/DocumentFragment;", "setM_docFrag", "(Lorg/w3c/dom/DocumentFragment;)V", "m_elemStack", "Ljava/util/Stack;", "Lorg/w3c/dom/Element;", "getM_elemStack", "()Ljava/util/Stack;", "setM_elemStack", "(Ljava/util/Stack;)V", "m_inCData", "getM_inCData", "setM_inCData", "(Z)V", "rootNode", "getRootNode", "writer", "Ljava/io/Writer;", "getWriter", "()Ljava/io/Writer;", "append", "", "newNode", "cdata", "ch", "", "start", "", "length", "characters", "charactersRaw", "comment", "endCDATA", "endDTD", "endDocument", "endElement", "ns", "", "localName", "name", "endEntity", "endPrefixMapping", "prefix", "entityReference", "ignorableWhitespace", "processingInstruction", "target", "data", "setDocumentLocator", "locator", "Lorg/xml/sax/Locator;", "setIDAttribute", "id", "elem", "skippedEntity", "startCDATA", "startDTD", "publicId", "systemId", "startDocument", "startElement", "atts", "Lorg/xml/sax/Attributes;", "startEntity", "startPrefixMapping", "uri", "pulsar-parse"})
public final class DOMBuilder
implements ContentHandler,
LexicalHandler {
    @NotNull
    private Document m_doc;
    @Nullable
    private DocumentFragment m_docFrag;
    @Nullable
    private Node currentNode;
    @NotNull
    private Stack<Element> m_elemStack;
    private boolean m_inCData;
    @Nullable
    private final Writer writer;

    @NotNull
    public final Document getM_doc() {
        return this.m_doc;
    }

    public final void setM_doc(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"<set-?>");
        this.m_doc = document;
    }

    @Nullable
    public final DocumentFragment getM_docFrag() {
        return this.m_docFrag;
    }

    public final void setM_docFrag(@Nullable DocumentFragment documentFragment) {
        this.m_docFrag = documentFragment;
    }

    @Nullable
    public final Node getCurrentNode() {
        return this.currentNode;
    }

    protected final void setCurrentNode(@Nullable Node node) {
        this.currentNode = node;
    }

    @NotNull
    protected final Stack<Element> getM_elemStack() {
        return this.m_elemStack;
    }

    protected final void setM_elemStack(@NotNull Stack<Element> stack) {
        Intrinsics.checkNotNullParameter(stack, (String)"<set-?>");
        this.m_elemStack = stack;
    }

    protected final boolean getM_inCData() {
        return this.m_inCData;
    }

    protected final void setM_inCData(boolean bl) {
        this.m_inCData = bl;
    }

    public DOMBuilder(@NotNull Document doc, @Nullable Node node) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.m_elemStack = new Stack();
        this.m_doc = doc;
        this.currentNode = node;
    }

    public DOMBuilder(@NotNull Document doc, @Nullable DocumentFragment docFrag) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.m_elemStack = new Stack();
        this.m_doc = doc;
        this.m_docFrag = docFrag;
    }

    public DOMBuilder(@NotNull Document doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.m_elemStack = new Stack();
        this.m_doc = doc;
    }

    @NotNull
    public final Node getRootNode() {
        Node node;
        if (this.m_docFrag != null) {
            DocumentFragment documentFragment = this.m_docFrag;
            Intrinsics.checkNotNull((Object)documentFragment);
            node = documentFragment;
        } else {
            node = this.m_doc;
        }
        return node;
    }

    @Nullable
    public final Writer getWriter() {
        return this.writer;
    }

    protected final void append(@NotNull Node newNode) throws SAXException {
        Intrinsics.checkNotNullParameter((Object)newNode, (String)"newNode");
        Node currentNode = this.currentNode;
        if (currentNode != null) {
            currentNode.appendChild(newNode);
        } else if (this.m_docFrag != null) {
            DocumentFragment documentFragment = this.m_docFrag;
            Intrinsics.checkNotNull((Object)documentFragment);
            documentFragment.appendChild(newNode);
        } else {
            boolean ok = true;
            short type = newNode.getNodeType();
            if (type == 3) {
                String data = newNode.getNodeValue();
                if (data != null) {
                    String $this$trim$iv = data;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    if (((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString().length() > 0) {
                        throw new SAXException("Warning: can't output text before document element!  Ignoring...");
                    }
                }
                ok = false;
            } else if (type == 1 && this.m_doc.getDocumentElement() != null) {
                throw new SAXException("Can't have more than one root on a DOM!");
            }
            if (ok) {
                this.m_doc.appendChild(newNode);
            }
        }
    }

    @Override
    public void setDocumentLocator(@NotNull Locator locator) {
        Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(@NotNull String ns, @NotNull String localName, @NotNull String name, @NotNull Attributes atts) throws SAXException {
        Element element;
        Element element2;
        Intrinsics.checkNotNullParameter((Object)ns, (String)"ns");
        Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)atts, (String)"atts");
        Element elem = null;
        if (ns.length() == 0) {
            element2 = this.m_doc.createElementNS(null, name);
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"m_doc.createElementNS(null, name)");
            element = element2;
        } else {
            element2 = this.m_doc.createElementNS(ns, name);
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"m_doc.createElementNS(ns, name)");
            element = element2;
        }
        elem = element;
        this.append(elem);
        try {
            int n;
            int nAtts = atts.getLength();
            if (nAtts != 0 && (n = 0) < nAtts) {
                do {
                    String attrNS;
                    int i;
                    if (StringsKt.equals((String)atts.getType(i = n++), (String)"ID", (boolean)true)) {
                        this.setIDAttribute(atts.getValue(i), elem);
                    }
                    if (Intrinsics.areEqual((Object)"", (Object)(attrNS = atts.getURI(i)))) {
                        attrNS = null;
                    }
                    String attrQName = atts.getQName(i);
                    Intrinsics.checkNotNullExpressionValue((Object)attrQName, (String)"attrQName");
                    if (StringsKt.startsWith$default((String)attrQName, (String)"xmlns:", (boolean)false, (int)2, null)) {
                        attrNS = "http://www.w3.org/2000/xmlns/";
                    }
                    elem.setAttributeNS(attrNS, attrQName, atts.getValue(i));
                } while (n < nAtts);
            }
            this.m_elemStack.push(elem);
            this.currentNode = elem;
        }
        catch (Exception de) {
            throw new SAXException(de);
        }
    }

    @Override
    public void endElement(@NotNull String ns, @NotNull String localName, @NotNull String name) throws SAXException {
        Node node;
        Intrinsics.checkNotNullParameter((Object)ns, (String)"ns");
        Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.m_elemStack.pop();
        if (this.m_elemStack.isEmpty()) {
            node = null;
        } else {
            Element element = this.m_elemStack.peek();
            if (element == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Node");
            }
            node = element;
        }
        this.currentNode = node;
    }

    public final void setIDAttribute(@Nullable String id, @Nullable Element elem) {
    }

    @Override
    public void characters(@NotNull char[] ch, int start, int length) throws SAXException {
        Node childNode;
        Node node;
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        if (this.isOutsideDocElem() && XMLCharacterRecognizer.INSTANCE.isWhiteSpace(ch, start, length)) {
            return;
        }
        if (this.m_inCData) {
            this.cdata(ch, start, length);
            return;
        }
        boolean bl = false;
        String s = new String(ch, start, length);
        if (this.currentNode != null) {
            Node node2 = this.currentNode;
            Intrinsics.checkNotNull((Object)node2);
            node = node2.getLastChild();
        } else {
            node = childNode = null;
        }
        if (childNode != null && childNode.getNodeType() == 3) {
            ((Text)childNode).appendData(s);
        } else {
            Text text = this.m_doc.createTextNode(s);
            Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
            this.append(text);
        }
    }

    public final void charactersRaw(@NotNull char[] ch, int start, int length) throws SAXException {
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        if (this.isOutsideDocElem() && XMLCharacterRecognizer.INSTANCE.isWhiteSpace(ch, start, length)) {
            return;
        }
        boolean bl = false;
        String s = new String(ch, start, length);
        Node node = this.m_doc.createProcessingInstruction("xslt-next-is-raw", "formatter-to-dom");
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"m_doc.createProcessingIn\u2026      \"formatter-to-dom\")");
        this.append(node);
        node = this.m_doc.createTextNode(s);
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"m_doc.createTextNode(s)");
        this.append(node);
    }

    @Override
    public void startEntity(@NotNull String name) throws SAXException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
    }

    @Override
    public void endEntity(@NotNull String name) throws SAXException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
    }

    public final void entityReference(@Nullable String name) throws SAXException {
        EntityReference entityReference = this.m_doc.createEntityReference(name);
        Intrinsics.checkNotNullExpressionValue((Object)entityReference, (String)"m_doc.createEntityReference(name)");
        this.append(entityReference);
    }

    @Override
    public void ignorableWhitespace(@NotNull char[] ch, int start, int length) throws SAXException {
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        if (this.isOutsideDocElem()) {
            return;
        }
        boolean bl = false;
        String s = new String(ch, start, length);
        Text text = this.m_doc.createTextNode(s);
        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"m_doc.createTextNode(s)");
        this.append(text);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isOutsideDocElem() {
        if (this.m_docFrag != null) return false;
        if (this.m_elemStack.size() != 0) return false;
        if (this.currentNode == null) return true;
        Node node = this.currentNode;
        Intrinsics.checkNotNull((Object)node);
        if (node.getNodeType() != 9) return false;
        return true;
    }

    @Override
    public void processingInstruction(@NotNull String target, @NotNull String data) throws SAXException {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ProcessingInstruction processingInstruction = this.m_doc.createProcessingInstruction(target, data);
        Intrinsics.checkNotNullExpressionValue((Object)processingInstruction, (String)"m_doc.createProcessingInstruction(target, data)");
        this.append(processingInstruction);
    }

    @Override
    public void comment(@NotNull char[] ch, int start, int length) throws SAXException {
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        if (start < 0 || length >= ch.length - start || length < 0) {
            return;
        }
        boolean bl = false;
        Comment comment = this.m_doc.createComment(new String(ch, start, length));
        Intrinsics.checkNotNullExpressionValue((Object)comment, (String)"m_doc.createComment(String(ch, start, length))");
        this.append(comment);
    }

    @Override
    public void startCDATA() throws SAXException {
        this.m_inCData = true;
        CDATASection cDATASection = this.m_doc.createCDATASection("");
        Intrinsics.checkNotNullExpressionValue((Object)cDATASection, (String)"m_doc.createCDATASection(\"\")");
        this.append(cDATASection);
    }

    @Override
    public void endCDATA() throws SAXException {
        this.m_inCData = false;
    }

    public final void cdata(@NotNull char[] ch, int start, int length) throws SAXException {
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        if (this.isOutsideDocElem() && XMLCharacterRecognizer.INSTANCE.isWhiteSpace(ch, start, length)) {
            return;
        }
        boolean bl = false;
        String s = new String(ch, start, length);
        Node node = this.currentNode;
        Intrinsics.checkNotNull((Object)node);
        Node n = node.getLastChild();
        if (n instanceof CDATASection) {
            ((CDATASection)n).appendData(s);
        } else if (n instanceof Comment) {
            ((Comment)n).appendData(s);
        }
    }

    @Override
    public void startDTD(@NotNull String name, @NotNull String publicId, @NotNull String systemId) throws SAXException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)publicId, (String)"publicId");
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startPrefixMapping(@NotNull String prefix, @NotNull String uri) throws SAXException {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
    }

    @Override
    public void endPrefixMapping(@NotNull String prefix) throws SAXException {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
    }

    @Override
    public void skippedEntity(@NotNull String name) throws SAXException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
    }
}

