/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.scoring;

import ai.platon.pulsar.common.ScoreVector;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.crawl.index.IndexDocument;
import ai.platon.pulsar.crawl.scoring.ScoringFilter;
import ai.platon.pulsar.persist.PageCounters;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.graph.WebEdge;
import ai.platon.pulsar.persist.graph.WebGraph;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lai/platon/pulsar/scoring/ContentAnalysisScoringFilter;", "Lai/platon/pulsar/crawl/scoring/ScoringFilter;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "calculateContentScore", "", "page", "Lai/platon/pulsar/persist/WebPage;", "getParams", "Lai/platon/pulsar/common/config/Params;", "updateContentScore", "", "pulsar-scoring"})
public class ContentAnalysisScoringFilter
implements ScoringFilter {
    @NotNull
    private final ImmutableConfig conf;

    public ContentAnalysisScoringFilter(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @NotNull
    public Params getParams() {
        return new Params();
    }

    public void updateContentScore(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        page.setContentScore(this.calculateContentScore(page));
    }

    protected final float calculateContentScore(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        float f1 = 1.2f;
        float f2 = 1.0f;
        float f3 = 1.2f;
        PageCounters pageCounters = page.getPageCounters();
        Intrinsics.checkNotNullExpressionValue((Object)pageCounters, (String)"page.pageCounters");
        PageCounters pageCounters2 = pageCounters;
        int re = pageCounters2.get((Enum)PageCounters.Ref.entity);
        int ra = pageCounters2.get((Enum)PageCounters.Ref.item);
        int rc = pageCounters2.get((Enum)PageCounters.Ref.ch);
        long days = ChronoUnit.DAYS.between(page.getRefContentPublishTime(), Instant.now());
        if (days > 3650L || days < 0L) {
            days = 0L;
        }
        return f1 * (float)ra + f2 * (float)(rc / 1000) - f3 * (float)days;
    }

    public void distributeScoreToOutlinks(@NotNull WebPage page, @NotNull WebGraph graph, @NotNull Collection<WebEdge> outgoingEdges, int allCount) {
        ScoringFilter.DefaultImpls.distributeScoreToOutlinks((ScoringFilter)this, (WebPage)page, (WebGraph)graph, outgoingEdges, (int)allCount);
    }

    @NotNull
    public ScoreVector generatorSortValue(@NotNull WebPage page, @NotNull ScoreVector initSort) {
        return ScoringFilter.DefaultImpls.generatorSortValue((ScoringFilter)this, (WebPage)page, (ScoreVector)initSort);
    }

    public float indexerScore(@NotNull String url, @NotNull IndexDocument doc, @NotNull WebPage page, float initScore) {
        return ScoringFilter.DefaultImpls.indexerScore((ScoringFilter)this, (String)url, (IndexDocument)doc, (WebPage)page, (float)initScore);
    }

    public void initialScore(@NotNull WebPage page) {
        ScoringFilter.DefaultImpls.initialScore((ScoringFilter)this, (WebPage)page);
    }

    public void injectedScore(@NotNull WebPage page) {
        ScoringFilter.DefaultImpls.injectedScore((ScoringFilter)this, (WebPage)page);
    }

    public void updateScore(@NotNull WebPage page, @NotNull WebGraph graph, @NotNull Collection<WebEdge> incomingEdges) {
        ScoringFilter.DefaultImpls.updateScore((ScoringFilter)this, (WebPage)page, (WebGraph)graph, incomingEdges);
    }
}

