/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.scoring;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.ScoreVector;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.crawl.filter.CrawlFilter;
import ai.platon.pulsar.crawl.index.IndexDocument;
import ai.platon.pulsar.crawl.scoring.Name;
import ai.platon.pulsar.crawl.scoring.NamedScoreVector;
import ai.platon.pulsar.persist.PageCounters;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.WebPageExt;
import ai.platon.pulsar.persist.graph.WebEdge;
import ai.platon.pulsar.persist.graph.WebGraph;
import ai.platon.pulsar.scoring.ContentAnalysisScoringFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J.\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\tH\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020&H\u0016J\b\u0010(\u001a\u00020)H\u0016J(\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\fH\u0016J\u0010\u00100\u001a\u00020\u001e2\u0006\u00101\u001a\u00020\u001bH\u0016J\u0010\u00102\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J&\u00103\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\f\u00104\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u0007*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0007*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0007*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lai/platon/pulsar/scoring/NewsMonitorScoringFilter;", "Lai/platon/pulsar/scoring/ContentAnalysisScoringFilter;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "contentScoreDivisor", "", "errorCounterDivisor", "externalScoreFactor", "", "impreciseLocalNow", "Ljava/time/LocalDateTime;", "impreciseNow", "Ljava/time/Instant;", "impreciseTomorrow", "internalScoreFactor", "maxPriorPages", "priorPageRate", "priorPages", "scorePower", "topN", "webGraphScoreDivisor", "calculateModifiedTime", "page", "Lai/platon/pulsar/persist/WebPage;", "calculatePriority", "distributeScoreToOutlinks", "", "graph", "Lai/platon/pulsar/persist/graph/WebGraph;", "outgoingEdges", "", "Lai/platon/pulsar/persist/graph/WebEdge;", "allCount", "generatorSortValue", "Lai/platon/pulsar/common/ScoreVector;", "initSort", "getParams", "Lai/platon/pulsar/common/config/Params;", "indexerScore", "url", "", "doc", "Lai/platon/pulsar/crawl/index/IndexDocument;", "initScore", "initialScore", "row", "injectedScore", "updateScore", "incomingEdges", "pulsar-scoring"})
public final class NewsMonitorScoringFilter
extends ContentAnalysisScoringFilter {
    private final Logger LOG;
    private final int topN;
    private final float priorPageRate;
    private final int maxPriorPages;
    private final float scorePower;
    private final float internalScoreFactor;
    private final float externalScoreFactor;
    private final int errorCounterDivisor;
    private final int webGraphScoreDivisor;
    private final int contentScoreDivisor;
    private final Instant impreciseNow;
    private final Instant impreciseTomorrow;
    private final LocalDateTime impreciseLocalNow;
    private int priorPages;

    public NewsMonitorScoringFilter(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(conf);
        this.LOG = LoggerFactory.getLogger(NewsMonitorScoringFilter.class);
        this.topN = conf.getInt("generate.topN", Integer.MAX_VALUE);
        this.priorPageRate = conf.getFloat("generate.detail.page.rate", 0.8f);
        this.maxPriorPages = MathKt.roundToInt((float)((float)this.topN * this.priorPageRate));
        this.scorePower = conf.getFloat("index.score.power", 0.5f);
        this.internalScoreFactor = conf.getFloat("db.score.link.internal", 1.0f);
        this.externalScoreFactor = conf.getFloat("db.score.link.external", 1.0f);
        this.errorCounterDivisor = conf.getInt("score.sort.error.counter.divisor", 20);
        this.webGraphScoreDivisor = conf.getInt("score.sort.web.graph.score.divisor", 20);
        this.contentScoreDivisor = conf.getInt("score.sort.content.score.divisor", 20);
        this.impreciseNow = Instant.now();
        this.impreciseTomorrow = this.impreciseNow.plus(1L, ChronoUnit.DAYS);
        this.impreciseLocalNow = LocalDateTime.now();
    }

    @Override
    @NotNull
    public Params getParams() {
        Object[] objectArray = new Object[]{"priorPageRate", Float.valueOf(this.priorPageRate), "maxPriorPages", this.maxPriorPages};
        Params params = Params.of((String)"topN", (Object)this.topN, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n                \"top\u2026, maxPriorPages\n        )");
        return params;
    }

    @Override
    public void injectedScore(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        float score = page.getScore();
        page.setCash(score);
    }

    @Override
    public void initialScore(@NotNull WebPage row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        row.setScore(0.0f);
        row.setCash(0.0f);
    }

    @Override
    @NotNull
    public ScoreVector generatorSortValue(@NotNull WebPage page, @NotNull ScoreVector initSort) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)initSort, (String)"initSort");
        int priority = this.calculatePriority(page);
        int distance = page.getDistance();
        Instant instant = page.getCreateTime();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"page.createTime");
        Instant createTime = instant;
        Instant modifiedTime = this.calculateModifiedTime(page);
        Duration createDuration = Duration.between(createTime, this.impreciseNow);
        long createdDays = createDuration.toDays();
        int inlinkOrder = page.getAnchorOrder();
        PageCounters pageCounters = page.getPageCounters();
        Intrinsics.checkNotNullExpressionValue((Object)pageCounters, (String)"page.pageCounters");
        PageCounters pageCounters2 = pageCounters;
        float fetchCount = page.getFetchCount();
        float refFetchErr = pageCounters2.get((Enum)PageCounters.Ref.fetchErr);
        float refParseErr = pageCounters2.get((Enum)PageCounters.Ref.parseErr);
        float refExtractErr = pageCounters2.get((Enum)PageCounters.Ref.extractErr);
        float refIndexErr = pageCounters2.get((Enum)PageCounters.Ref.indexErr);
        float refFetchErrDensity = refFetchErr == 0.0f ? 0.0f : fetchCount / refFetchErr / (float)this.errorCounterDivisor;
        float refParseErrDensity = refParseErr == 0.0f ? 0.0f : fetchCount / refParseErr / (float)this.errorCounterDivisor;
        float refExtractErrDensity = refExtractErr == 0.0f ? 0.0f : fetchCount / refExtractErr / (float)this.errorCounterDivisor;
        float refIndexErrDensity = refIndexErr == 0.0f ? 0.0f : fetchCount / refIndexErr / (float)this.errorCounterDivisor;
        NamedScoreVector score = new NamedScoreVector();
        score.setValue(Name.priority, priority);
        score.setValue(Name.distance, -distance);
        if (createdDays <= 3L) {
            String string = DateTimes.INSTANCE.format(createTime, "yyyyMMddHH");
            boolean bl = false;
            score.setValue(Name.createTime, Integer.parseInt(string));
        }
        score.setValue(Name.contentScore, page.getContentScore() / (float)this.contentScoreDivisor);
        score.setValue(Name.webGraphScore, page.getScore() / (float)this.webGraphScoreDivisor);
        score.setValue(Name.refFetchErrDensity, refFetchErrDensity);
        score.setValue(Name.refParseErrDensity, refParseErrDensity);
        score.setValue(Name.refExtractErrDensity, refExtractErrDensity);
        score.setValue(Name.refIndexErrDensity, refIndexErrDensity);
        score.setValue(Name.modifyTime, NumberUtils.toInt((String)DateTimes.INSTANCE.format(modifiedTime, "yyyyMMddHH"), (int)0));
        score.setValue(Name.anchorOrder, -inlinkOrder);
        return (ScoreVector)score;
    }

    private final Instant calculateModifiedTime(WebPage page) {
        WebPageExt pageExt = new WebPageExt(page);
        Instant instant = pageExt.sniffModifiedTime();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"pageExt.sniffModifiedTime()");
        Instant modifiedTime = instant;
        if (modifiedTime.isAfter(this.impreciseTomorrow)) {
            instant = Instant.EPOCH;
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"EPOCH");
            modifiedTime = instant;
        }
        if (page.getFetchCount() == 0) {
            instant = page.getCreateTime();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"page.createTime");
            modifiedTime = instant;
        }
        return modifiedTime;
    }

    /*
     * Unable to fully structure code
     */
    private final int calculatePriority(WebPage page) {
        block9: {
            block10: {
                var3_2 = page.getCreateTime();
                Intrinsics.checkNotNullExpressionValue((Object)var3_2, (String)"page.createTime");
                createTime = var3_2;
                createDuration = Duration.between(createTime, this.impreciseNow);
                createdDays = createDuration.toDays();
                createdHours = createDuration.toHours();
                priority = 10000;
                if (page.isSeed()) break block9;
                if (page.getFetchCount() != 0 || this.priorPages >= this.maxPriorPages) break block10;
                if (page.getPageCategory().isDetail()) ** GOTO lbl-1000
                var10_7 = page.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)var10_7, (String)"page.url");
                if (CrawlFilter.Companion.guessPageCategory(var10_7).isDetail()) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = isDetail = false;
                }
                if (createdDays == 0L) {
                    priority += isDetail != false ? 300 : 200;
                } else if (isDetail && createdDays <= 3L) {
                    priority += 100;
                }
            }
            if (priority > 10000) {
                isDetail = this;
                ++isDetail.priorPages;
                isDetail.priorPages;
            }
        }
        if (page.isSeed()) {
            if (createdDays < 7L) {
                priority += (int)((long)1000 + ((long)7 - createdDays));
            }
            v1 = 2L <= (hour = (long)this.impreciseLocalNow.getHour()) ? hour <= 6L : false;
            if (v1) {
                priority -= 100;
            }
        }
        return priority;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateScore(@NotNull WebPage page, @NotNull WebGraph graph, @NotNull Collection<WebEdge> incomingEdges) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter(incomingEdges, (String)"incomingEdges");
        Iterable $this$sumByDouble$iv = incomingEdges;
        boolean $i$f$sumByDouble = false;
        double sum$iv = 0.0;
        for (Object element$iv : $this$sumByDouble$iv) {
            void it;
            WebEdge webEdge = (WebEdge)element$iv;
            double d = sum$iv;
            boolean bl = false;
            double d2 = it.isLoop() ? 0.0 : graph.getEdgeWeight((Object)it);
            sum$iv = d + d2;
        }
        float score = (float)sum$iv;
        page.setScore(page.getScore() + score);
        page.setCash(page.getCash() + score);
    }

    @Override
    public void distributeScoreToOutlinks(@NotNull WebPage page, @NotNull WebGraph graph, @NotNull Collection<WebEdge> outgoingEdges, int allCount) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter(outgoingEdges, (String)"outgoingEdges");
        float cash = page.getCash();
        if (cash == 0.0f) {
            return;
        }
        float scoreUnit = cash / (float)allCount;
        float internalScore = scoreUnit * this.internalScoreFactor;
        float externalScore = scoreUnit * this.externalScoreFactor;
        for (WebEdge edge : outgoingEdges) {
            if (edge.isLoop()) continue;
            double score = graph.getEdgeWeight((Object)edge);
            try {
                String toHost = new URL(edge.getTarget().getUrl()).getHost();
                String fromHost = new URL(page.getUrl()).getHost();
                if (StringsKt.equals((String)toHost, (String)fromHost, (boolean)true)) {
                    graph.setEdgeWeight((Object)edge, score + (double)internalScore);
                    continue;
                }
                graph.setEdgeWeight((Object)edge, score + (double)externalScore);
            }
            catch (MalformedURLException e) {
                this.LOG.error("Failed with the following MalformedURLException: ", (Throwable)e);
                graph.setEdgeWeight((Object)edge, score + (double)externalScore);
            }
        }
        page.setCash(0.0f);
    }

    @Override
    public float indexerScore(@NotNull String url, @NotNull IndexDocument doc, @NotNull WebPage page, float initScore) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        float f = page.getScore();
        float f2 = this.scorePower;
        boolean bl = false;
        return (float)Math.pow(f, f2) * initScore;
    }
}

