/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.scoring;

import ai.platon.pulsar.common.ScoreVector;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.crawl.filter.CrawlFilter;
import ai.platon.pulsar.crawl.index.IndexDocument;
import ai.platon.pulsar.crawl.scoring.Name;
import ai.platon.pulsar.crawl.scoring.NamedScoreVector;
import ai.platon.pulsar.crawl.scoring.ScoringFilter;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.graph.WebEdge;
import ai.platon.pulsar.persist.graph.WebGraph;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0015"}, d2={"Lai/platon/pulsar/scoring/ProductMonitorScoringFilter;", "Lai/platon/pulsar/crawl/scoring/ScoringFilter;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "calculatePriority", "", "page", "Lai/platon/pulsar/persist/WebPage;", "generatorSortValue", "Lai/platon/pulsar/common/ScoreVector;", "initSort", "getParams", "Lai/platon/pulsar/common/config/Params;", "initialScore", "", "injectedScore", "isDetail", "", "isIndex", "Companion", "pulsar-scoring"})
public final class ProductMonitorScoringFilter
implements ScoringFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int INDEX_PAGE_PRIORITY = 10000;
    private static final int DETAIL_PAGE_PRIORITY = 10200;
    private static final int SEED_PRIORITY = 10300;

    public ProductMonitorScoringFilter(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
    }

    @NotNull
    public Params getParams() {
        Params params = Params.of((String)"className", (Object)this.getClass().getName(), (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n                \"cla\u2026class.java.name\n        )");
        return params;
    }

    public void injectedScore(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        page.setCash(page.getScore());
    }

    public void initialScore(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        page.setScore(0.0f);
        page.setCash(0.0f);
    }

    @NotNull
    public ScoreVector generatorSortValue(@NotNull WebPage page, @NotNull ScoreVector initSort) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)initSort, (String)"initSort");
        NamedScoreVector score = new NamedScoreVector();
        score.setValue(Name.priority, this.calculatePriority(page));
        if (this.isDetail(page)) {
            score.setValue(Name.anchorOrder, -page.getAnchorOrder());
        }
        return (ScoreVector)score;
    }

    private final int calculatePriority(WebPage page) {
        int priority = page.isSeed() ? 10300 : (this.isIndex(page) ? 10000 : (this.isDetail(page) ? 10200 : 0));
        return priority;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIndex(WebPage page) {
        if (page.getPageCategory().isIndex()) return true;
        String string = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
        if (!CrawlFilter.Companion.getPageCategory(string).isIndex()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDetail(WebPage page) {
        if (page.getPageCategory().isDetail()) return true;
        String string = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
        if (!CrawlFilter.Companion.getPageCategory(string).isDetail()) return false;
        return true;
    }

    public void distributeScoreToOutlinks(@NotNull WebPage page, @NotNull WebGraph graph, @NotNull Collection<WebEdge> outgoingEdges, int allCount) {
        ScoringFilter.DefaultImpls.distributeScoreToOutlinks((ScoringFilter)this, (WebPage)page, (WebGraph)graph, outgoingEdges, (int)allCount);
    }

    public float indexerScore(@NotNull String url, @NotNull IndexDocument doc, @NotNull WebPage page, float initScore) {
        return ScoringFilter.DefaultImpls.indexerScore((ScoringFilter)this, (String)url, (IndexDocument)doc, (WebPage)page, (float)initScore);
    }

    public void updateContentScore(@NotNull WebPage page) {
        ScoringFilter.DefaultImpls.updateContentScore((ScoringFilter)this, (WebPage)page);
    }

    public void updateScore(@NotNull WebPage page, @NotNull WebGraph graph, @NotNull Collection<WebEdge> incomingEdges) {
        ScoringFilter.DefaultImpls.updateScore((ScoringFilter)this, (WebPage)page, (WebGraph)graph, incomingEdges);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lai/platon/pulsar/scoring/ProductMonitorScoringFilter$Companion;", "", "()V", "DETAIL_PAGE_PRIORITY", "", "INDEX_PAGE_PRIORITY", "SEED_PRIORITY", "pulsar-scoring"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

