/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.scoring.link;

import ai.platon.pulsar.common.ScoreVector;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.crawl.index.IndexDocument;
import ai.platon.pulsar.crawl.scoring.ScoringFilter;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.graph.WebEdge;
import ai.platon.pulsar.persist.graph.WebGraph;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J(\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lai/platon/pulsar/scoring/link/LinkAnalysisScoringFilter;", "Lai/platon/pulsar/crawl/scoring/ScoringFilter;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "normalizedScore", "", "getParams", "Lai/platon/pulsar/common/config/Params;", "indexerScore", "url", "", "doc", "Lai/platon/pulsar/crawl/index/IndexDocument;", "page", "Lai/platon/pulsar/persist/WebPage;", "initScore", "pulsar-scoring"})
public final class LinkAnalysisScoringFilter
implements ScoringFilter {
    private final float normalizedScore;

    public LinkAnalysisScoringFilter(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.normalizedScore = conf.getFloat("link.analyze.normalize.score", 1.0f);
    }

    @NotNull
    public Params getParams() {
        return new Params();
    }

    public float indexerScore(@NotNull String url, @NotNull IndexDocument doc, @NotNull WebPage page, float initScore) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        return this.normalizedScore * page.getScore();
    }

    public void distributeScoreToOutlinks(@NotNull WebPage page, @NotNull WebGraph graph, @NotNull Collection<WebEdge> outgoingEdges, int allCount) {
        ScoringFilter.DefaultImpls.distributeScoreToOutlinks((ScoringFilter)this, (WebPage)page, (WebGraph)graph, outgoingEdges, (int)allCount);
    }

    @NotNull
    public ScoreVector generatorSortValue(@NotNull WebPage page, @NotNull ScoreVector initSort) {
        return ScoringFilter.DefaultImpls.generatorSortValue((ScoringFilter)this, (WebPage)page, (ScoreVector)initSort);
    }

    public void initialScore(@NotNull WebPage page) {
        ScoringFilter.DefaultImpls.initialScore((ScoringFilter)this, (WebPage)page);
    }

    public void injectedScore(@NotNull WebPage page) {
        ScoringFilter.DefaultImpls.injectedScore((ScoringFilter)this, (WebPage)page);
    }

    public void updateContentScore(@NotNull WebPage page) {
        ScoringFilter.DefaultImpls.updateContentScore((ScoringFilter)this, (WebPage)page);
    }

    public void updateScore(@NotNull WebPage page, @NotNull WebGraph graph, @NotNull Collection<WebEdge> incomingEdges) {
        ScoringFilter.DefaultImpls.updateScore((ScoringFilter)this, (WebPage)page, (WebGraph)graph, incomingEdges);
    }
}

