/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.scoring.opic;

import ai.platon.pulsar.common.ScoreVector;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.crawl.index.IndexDocument;
import ai.platon.pulsar.crawl.scoring.ScoringFilter;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.graph.WebEdge;
import ai.platon.pulsar.persist.graph.WebGraph;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\bH\u0016J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010 \u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lai/platon/pulsar/scoring/opic/OPICScoringFilter;", "Lai/platon/pulsar/crawl/scoring/ScoringFilter;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "externalScoreFactor", "", "internalScoreFactor", "scorePower", "distributeScoreToOutlinks", "", "page", "Lai/platon/pulsar/persist/WebPage;", "graph", "Lai/platon/pulsar/persist/graph/WebGraph;", "outgoingEdges", "", "Lai/platon/pulsar/persist/graph/WebEdge;", "allCount", "", "getParams", "Lai/platon/pulsar/common/config/Params;", "indexerScore", "url", "", "doc", "Lai/platon/pulsar/crawl/index/IndexDocument;", "initScore", "initialScore", "injectedScore", "updateScore", "incomingEdges", "pulsar-scoring"})
public final class OPICScoringFilter
implements ScoringFilter {
    @NotNull
    private final ImmutableConfig conf;
    private final float scorePower;
    private final float internalScoreFactor;
    private final float externalScoreFactor;

    public OPICScoringFilter(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.scorePower = this.conf.getFloat("index.score.power", 0.5f);
        this.internalScoreFactor = this.conf.getFloat("db.score.link.internal", 1.0f);
        this.externalScoreFactor = this.conf.getFloat("db.score.link.external", 1.0f);
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @NotNull
    public Params getParams() {
        Object[] objectArray = new Object[]{"internalScoreFactor", Float.valueOf(this.internalScoreFactor), "externalScoreFactor", Float.valueOf(this.externalScoreFactor)};
        Params params = Params.of((String)"scorePower", (Object)Float.valueOf(this.scorePower), (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n                \"sco\u2026rnalScoreFactor\n        )");
        return params;
    }

    public void injectedScore(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        float score = page.getScore();
        page.setCash(score);
    }

    public void initialScore(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        page.setScore(0.0f);
        page.setCash(0.0f);
    }

    /*
     * WARNING - void declaration
     */
    public void updateScore(@NotNull WebPage page, @NotNull WebGraph graph, @NotNull Collection<WebEdge> incomingEdges) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter(incomingEdges, (String)"incomingEdges");
        Iterable iterable = incomingEdges;
        boolean bl = false;
        double d = 0.0;
        for (Object t : iterable) {
            void it;
            WebEdge webEdge = (WebEdge)t;
            double d2 = d;
            boolean bl2 = false;
            double d3 = it.isLoop() ? 0.0 : graph.getEdgeWeight((Object)it);
            d = d2 + d3;
        }
        float score = (float)d;
        page.setScore(page.getScore() + score);
        page.setCash(page.getCash() + score);
    }

    public void distributeScoreToOutlinks(@NotNull WebPage page, @NotNull WebGraph graph, @NotNull Collection<WebEdge> outgoingEdges, int allCount) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter(outgoingEdges, (String)"outgoingEdges");
        float cash = page.getCash();
        if (cash == 0.0f) {
            return;
        }
        float scoreUnit = cash / (float)allCount;
        float internalScore = scoreUnit * this.internalScoreFactor;
        float externalScore = scoreUnit * this.externalScoreFactor;
        for (WebEdge edge : outgoingEdges) {
            if (edge.isLoop()) continue;
            double score = graph.getEdgeWeight((Object)edge);
            try {
                String toHost = new URL(edge.getTargetUrl()).getHost();
                String fromHost = new URL(page.getUrl()).getHost();
                if (StringsKt.equals((String)toHost, (String)fromHost, (boolean)true)) {
                    graph.setEdgeWeight((Object)edge, score + (double)internalScore);
                    continue;
                }
                graph.setEdgeWeight((Object)edge, score + (double)externalScore);
            }
            catch (MalformedURLException e) {
                ScoringFilter.Companion.getLOG().error("Failed to distribute score ..." + e);
                graph.setEdgeWeight((Object)edge, score + (double)externalScore);
            }
        }
        page.setCash(0.0f);
    }

    public float indexerScore(@NotNull String url, @NotNull IndexDocument doc, @NotNull WebPage page, float initScore) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        double d = page.getScore();
        double d2 = this.scorePower;
        boolean bl = false;
        return (float)Math.pow(d, d2) * initScore;
    }

    @NotNull
    public ScoreVector generatorSortValue(@NotNull WebPage page, @NotNull ScoreVector initSort) {
        return ScoringFilter.DefaultImpls.generatorSortValue((ScoringFilter)this, (WebPage)page, (ScoreVector)initSort);
    }

    public void updateContentScore(@NotNull WebPage page) {
        ScoringFilter.DefaultImpls.updateContentScore((ScoringFilter)this, (WebPage)page);
    }
}

