/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.test.base;

import ai.stapi.graph.AttributeContainer;
import ai.stapi.graph.Graph;
import ai.stapi.graph.graphelements.Edge;
import ai.stapi.graph.graphelements.Node;
import ai.stapi.graph.inMemoryGraph.InMemoryGraphRepository;
import ai.stapi.graph.renderer.infrastructure.idLessTextRenderer.IdLessTextGraphRenderer;
import ai.stapi.graph.renderer.infrastructure.idLessTextRenderer.IdLessTextRendererOptions;
import ai.stapi.graph.renderer.infrastructure.idLessTextRenderer.attribute.TextAttributeContainerRenderer;
import ai.stapi.graph.renderer.infrastructure.idLessTextRenderer.edge.IdLessTextEdgeRenderer;
import ai.stapi.graph.renderer.infrastructure.idLessTextRenderer.node.IdLessTextNodeRenderer;
import ai.stapi.graph.renderer.infrastructure.textRenderer.edge.TextEdgeRenderer;
import ai.stapi.graph.renderer.infrastructure.textRenderer.node.TextNodeRenderer;
import ai.stapi.graph.traversableGraphElements.TraversableEdge;
import ai.stapi.graph.traversableGraphElements.TraversableGraphElement;
import ai.stapi.graph.traversableGraphElements.TraversableNode;
import ai.stapi.objectRenderer.infrastructure.objectToJsonStringRenderer.ObjectToJSonStringOptions;
import ai.stapi.objectRenderer.infrastructure.objectToJsonStringRenderer.ObjectToJsonStringRenderer;
import ai.stapi.objectRenderer.model.RenderOutput;
import ai.stapi.objectRenderer.model.RendererOptions;
import ai.stapi.test.FixtureFileLoadableTestTrait;
import ai.stapi.utils.LineFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.approvaltests.Approvals;
import org.approvaltests.core.Options;
import org.approvaltests.reporters.JunitReporter;
import org.approvaltests.reporters.UseReporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;

@UseReporter(value={JunitReporter.class})
public abstract class AbstractUnitTestCase
implements FixtureFileLoadableTestTrait {
    private final TextAttributeContainerRenderer textAttributeContainerRenderer = new TextAttributeContainerRenderer();
    protected IdLessTextNodeRenderer idLessTextNodeRenderer = new IdLessTextNodeRenderer(this.textAttributeContainerRenderer);
    protected TextNodeRenderer textNodeRenderer = new TextNodeRenderer(this.idLessTextNodeRenderer);
    protected IdLessTextEdgeRenderer idLessTextEdgeRenderer = new IdLessTextEdgeRenderer(this.textAttributeContainerRenderer);
    protected IdLessTextGraphRenderer idLessTextGraphRenderer = new IdLessTextGraphRenderer(this.idLessTextNodeRenderer, this.idLessTextEdgeRenderer);
    protected TextEdgeRenderer textEdgeRenderer = new TextEdgeRenderer(this.idLessTextEdgeRenderer);
    protected IdLessTextGraphRenderer graphRenderer = new IdLessTextGraphRenderer(this.idLessTextNodeRenderer, this.idLessTextEdgeRenderer);
    protected ObjectToJsonStringRenderer objectToJsonStringRenderer = new ObjectToJsonStringRenderer();

    protected void thenGraphApproved(Graph actualGraph) {
        this.thenGraphApproved(new InMemoryGraphRepository(actualGraph));
    }

    protected void thenGraphApproved(InMemoryGraphRepository actualGraph) {
        String textRenderedGraph = this.idLessTextGraphRenderer.render(actualGraph, (ai.stapi.graph.renderer.model.nodeRenderer.RendererOptions)this.getRenderOptions()).toPrintableString();
        Approvals.verify((Object)textRenderedGraph, (String)"txt");
    }

    protected void thenGraphApproved(Graph actualGraph, Options options) {
        this.thenGraphApproved(new InMemoryGraphRepository(actualGraph), options);
    }

    protected void thenGraphApproved(InMemoryGraphRepository actualGraph, Options options) {
        String textRenderedGraph = this.idLessTextGraphRenderer.render(actualGraph, (ai.stapi.graph.renderer.model.nodeRenderer.RendererOptions)this.getRenderOptions()).toPrintableString();
        Approvals.verify((Object)textRenderedGraph, (String)"txt", (Options)options);
    }

    protected void thenNodeApproved(TraversableNode node) {
        Assertions.assertNotNull((Object)node);
        String renderedNode = this.idLessTextNodeRenderer.render(node).toPrintableString();
        Approvals.verify((String)renderedNode);
    }

    protected void thenNodesApproved(List<TraversableNode> nodes) {
        Assertions.assertNotNull(nodes);
        if (nodes.size() == 0) {
            Approvals.verify(new ArrayList());
            return;
        }
        Stream<String> renderedNodes = nodes.stream().map(node -> this.idLessTextNodeRenderer.render(node).toPrintableString()).sorted();
        Approvals.verify((String)LineFormatter.createLines(renderedNodes));
    }

    protected void thenUnsortedNodesApproved(List<TraversableNode> nodes) {
        Assertions.assertNotNull(nodes);
        if (nodes.size() == 0) {
            Approvals.verify(new ArrayList());
            return;
        }
        Stream<String> renderedNodes = nodes.stream().map(node -> this.idLessTextNodeRenderer.render(node).toPrintableString());
        Approvals.verify((String)LineFormatter.createLines(renderedNodes));
    }

    protected void thenGraphElementApproved(TraversableGraphElement graphElement) {
        if (graphElement instanceof TraversableNode) {
            TraversableNode node = (TraversableNode)graphElement;
            this.thenNodeApproved(node);
            return;
        }
        if (graphElement instanceof TraversableEdge) {
            TraversableEdge edge = (TraversableEdge)graphElement;
            this.thenEdgeApproved(edge);
            return;
        }
        Assertions.fail((String)"This should never happen.");
    }

    protected void thenGraphElementsApproved(List<TraversableGraphElement> graphElements) {
        Assertions.assertNotNull(graphElements);
        if (graphElements.size() == 0) {
            Approvals.verify(new ArrayList());
            return;
        }
        if (graphElements.get(0) instanceof TraversableNode) {
            List<TraversableNode> nodes = graphElements.stream().map(node -> (TraversableNode)node).toList();
            this.thenNodesApproved(nodes);
        }
        if (graphElements.get(0) instanceof TraversableEdge) {
            List<TraversableEdge> edges = graphElements.stream().map(edge -> (TraversableEdge)edge).toList();
            this.thenEdgesApproved(edges);
        }
    }

    protected void thenUnsortedGraphElementsApproved(List<TraversableGraphElement> graphElements) {
        Assertions.assertNotNull(graphElements);
        if (graphElements.size() == 0) {
            Approvals.verify(new ArrayList());
            return;
        }
        if (graphElements.get(0) instanceof TraversableNode) {
            List<TraversableNode> nodes = graphElements.stream().map(node -> (TraversableNode)node).toList();
            this.thenUnsortedNodesApproved(nodes);
        }
        if (graphElements.get(0) instanceof TraversableEdge) {
            List<TraversableEdge> edges = graphElements.stream().map(edge -> (TraversableEdge)edge).toList();
            this.thenUnsortedEdgesApproved(edges);
        }
    }

    protected void thenEdgeApproved(TraversableEdge edge) {
        String renderEdge = this.idLessTextEdgeRenderer.render(edge, (ai.stapi.graph.renderer.model.nodeRenderer.RendererOptions)this.getRenderOptions()).toPrintableString();
        Approvals.verify((String)renderEdge);
    }

    protected void thenEdgesApproved(List<TraversableEdge> edges) {
        Assertions.assertNotNull(edges);
        if (edges.size() == 0) {
            Approvals.verify(new ArrayList());
            return;
        }
        Stream<String> renderedEdges = edges.stream().map(edge -> this.idLessTextEdgeRenderer.render(edge).toPrintableString()).sorted();
        Approvals.verify((String)LineFormatter.createLines(renderedEdges));
    }

    protected void thenUnsortedEdgesApproved(List<TraversableEdge> edges) {
        Assertions.assertNotNull(edges);
        if (edges.size() == 0) {
            Approvals.verify(new ArrayList());
            return;
        }
        Stream<String> renderedEdges = edges.stream().map(edge -> this.idLessTextEdgeRenderer.render(edge).toPrintableString());
        Approvals.verify((String)LineFormatter.createLines(renderedEdges));
    }

    protected void thenIdLessGraphsAreEqual(Graph expected, Graph actual) {
        this.thenIdLessGraphsAreEqual(new InMemoryGraphRepository(expected), new InMemoryGraphRepository(actual));
    }

    protected void thenIdLessGraphsAreEqual(InMemoryGraphRepository expected, InMemoryGraphRepository actual) {
        String renderedExpected = this.idLessTextGraphRenderer.render(expected, (ai.stapi.graph.renderer.model.nodeRenderer.RendererOptions)this.getRenderOptions()).toPrintableString();
        String renderedActual = this.idLessTextGraphRenderer.render(actual, (ai.stapi.graph.renderer.model.nodeRenderer.RendererOptions)this.getRenderOptions()).toPrintableString();
        Assertions.assertEquals((Object)renderedExpected, (Object)renderedActual);
    }

    protected void thenNodesAreSame(Node expectedNode, TraversableNode actualNode) {
        TraversableNode traversableExpectedNode = new Graph(new AttributeContainer[]{expectedNode}).traversable().loadNode(expectedNode.getId(), expectedNode.getType());
        String renderedExpected = this.textNodeRenderer.render(traversableExpectedNode).toPrintableString();
        String renderedActual = this.textNodeRenderer.render(actualNode).toPrintableString();
        Assertions.assertEquals((Object)renderedExpected, (Object)renderedActual);
    }

    protected void thenEdgesAreSame(Edge expectedEdge, TraversableEdge actualEdge) {
        TraversableEdge traversableExpectedEdge = new Graph(new AttributeContainer[]{new Node(expectedEdge.getNodeFromId(), expectedEdge.getNodeFromType()), new Node(expectedEdge.getNodeToId(), expectedEdge.getNodeToType()), expectedEdge}).traversable().loadEdge(expectedEdge.getId(), expectedEdge.getType());
        String renderedExpected = this.textEdgeRenderer.render(traversableExpectedEdge).toPrintableString();
        String renderedActual = this.textEdgeRenderer.render(actualEdge).toPrintableString();
        Assertions.assertEquals((Object)renderedExpected, (Object)renderedActual);
    }

    protected void thenGraphsAreSame(Graph expectedGraph, Graph actualGraph) {
        this.thenGraphsAreSame(new InMemoryGraphRepository(expectedGraph), new InMemoryGraphRepository(actualGraph));
    }

    protected void thenGraphsAreSame(InMemoryGraphRepository expectedGraph, InMemoryGraphRepository actualGraph) {
        String renderedExpected = this.idLessTextGraphRenderer.render(expectedGraph, (ai.stapi.graph.renderer.model.nodeRenderer.RendererOptions)this.getRenderOptions()).toPrintableString();
        String renderedActual = this.idLessTextGraphRenderer.render(actualGraph, (ai.stapi.graph.renderer.model.nodeRenderer.RendererOptions)this.getRenderOptions()).toPrintableString();
        Assertions.assertEquals((Object)renderedExpected, (Object)renderedActual);
    }

    protected void thenEdgesHaveSameIdAndTypeAndNodeIds(Edge expectedEdge, TraversableEdge actualEdge) {
        Assertions.assertEquals((Object)expectedEdge.getId(), (Object)actualEdge.getId(), (String)"Edges have different EdgeIds.");
        Assertions.assertEquals((Object)expectedEdge.getType(), (Object)actualEdge.getType(), (String)"Edges have different type.");
        Assertions.assertEquals((Object)expectedEdge.getNodeFromId(), (Object)actualEdge.getNodeFrom().getId(), (String)"Edges have different NodeFrom Id.");
        Assertions.assertEquals((Object)expectedEdge.getNodeToId(), (Object)actualEdge.getNodeTo().getId(), (String)"Edges have different NodeTo Id.");
    }

    protected void thenObjectApproved(Object obj) {
        ObjectToJSonStringOptions options = new ObjectToJSonStringOptions(new ObjectToJSonStringOptions.RenderFeature[]{ObjectToJSonStringOptions.RenderFeature.SORT_FIELDS, ObjectToJSonStringOptions.RenderFeature.HIDE_IDS});
        this.thenObjectApproved(obj, options);
    }

    protected void thenObjectApproved(Object obj, ObjectToJSonStringOptions.RenderFeature ... features) {
        ObjectToJSonStringOptions options = new ObjectToJSonStringOptions(features);
        this.thenObjectApproved(obj, options);
    }

    protected void thenObjectApproved(Object obj, List<ObjectToJSonStringOptions.RenderFeature> features) {
        ObjectToJSonStringOptions options = new ObjectToJSonStringOptions(features);
        this.thenObjectApproved(obj, options);
    }

    protected void thenObjectApprovedWithoutSorting(Object obj) {
        ObjectToJSonStringOptions options = new ObjectToJSonStringOptions(new ObjectToJSonStringOptions.RenderFeature[]{ObjectToJSonStringOptions.RenderFeature.HIDE_IDS});
        this.thenObjectApproved(obj, options);
    }

    protected void thenObjectApprovedWithShownIds(Object obj) {
        ObjectToJSonStringOptions options = new ObjectToJSonStringOptions(new ObjectToJSonStringOptions.RenderFeature[]{ObjectToJSonStringOptions.RenderFeature.SORT_FIELDS});
        this.thenObjectApproved(obj, options);
    }

    protected void thenObjectApproved(Object obj, ObjectToJSonStringOptions options) {
        RenderOutput objRender = this.objectToJsonStringRenderer.render(obj, (RendererOptions)options);
        Approvals.verify((String)objRender.toPrintableString().replace("\\n", System.lineSeparator()));
    }

    protected void thenStringApproved(String actual) {
        Approvals.verify((String)actual.replace("\\n", System.lineSeparator()));
    }

    protected void thenObjectsEquals(Object expected, Object actual, ObjectToJSonStringOptions options) {
        RenderOutput expectedRender = this.objectToJsonStringRenderer.render(expected, (RendererOptions)options);
        RenderOutput actualRender = this.objectToJsonStringRenderer.render(actual, (RendererOptions)options);
        Assertions.assertEquals((Object)expectedRender.toPrintableString(), (Object)actualRender.toPrintableString(), (String)"Objects do not match!");
    }

    protected void thenObjectsEquals(Object expected, Object actual) {
        this.thenObjectsEquals(expected, actual, new ObjectToJSonStringOptions(new ObjectToJSonStringOptions.RenderFeature[]{ObjectToJSonStringOptions.RenderFeature.HIDE_IDS, ObjectToJSonStringOptions.RenderFeature.SORT_FIELDS}));
    }

    protected <T extends Throwable> T thenExceptionMessageApprovedWithHiddenUuids(Class<T> exception, Executable throwable) {
        Throwable error = Assertions.assertThrows(exception, (Executable)throwable);
        String toApprove = error.getMessage().replaceAll("([a-f0-9]{8}(-[a-f0-9]{4}){4}[a-f0-9]{8})", "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxx");
        Approvals.verify((String)toApprove);
        return (T)error;
    }

    protected <T extends Throwable> T thenExceptionMessageApproved(Class<T> exception, Executable throwable) {
        Throwable error = Assertions.assertThrows(exception, (Executable)throwable);
        Approvals.verify((String)error.getMessage());
        return (T)error;
    }

    protected IdLessTextRendererOptions getRenderOptions() {
        return new IdLessTextRendererOptions();
    }
}

