/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.graphLoader.inmemory;

import ai.stapi.graph.attribute.Attribute;
import ai.stapi.graph.attribute.LeafAttribute;
import ai.stapi.graph.attribute.ListAttribute;
import ai.stapi.graph.attribute.SetAttribute;
import ai.stapi.graph.attribute.attributeValue.AttributeValue;
import ai.stapi.graph.traversableGraphElements.TraversableGraphElement;
import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.GraphDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.PositiveGraphDescription;
import ai.stapi.graphoperations.graphLoader.inmemory.AbstractInMemorySearchOptionResolver;
import ai.stapi.graphoperations.graphLoader.inmemory.InMemoryGraphLoader;
import ai.stapi.graphoperations.graphLoader.inmemory.InMemorySearchResolvingContext;
import ai.stapi.graphoperations.graphLoader.search.AbstractSearchOptionResolver;
import ai.stapi.graphoperations.graphLoader.search.sortOption.AbstractSortOption;
import ai.stapi.graphoperations.graphLoader.search.sortOption.SortOption;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import java.util.List;

public abstract class InMemorySortResolver
extends AbstractInMemorySearchOptionResolver<SortOption> {
    private final InMemoryGraphLoader inMemoryGraphLoader;

    protected InMemorySortResolver(StructureSchemaFinder structureSchemaFinder, InMemoryGraphLoader inMemoryGraphLoader) {
        super(structureSchemaFinder);
        this.inMemoryGraphLoader = inMemoryGraphLoader;
    }

    protected AttributeValue<?> getSortingValue(AbstractSortOption sortOption, TraversableGraphElement graphElement, AttributeValue<?> defaultValue, InMemorySearchResolvingContext context) {
        if (sortOption.isLeaf()) {
            String attributeName = sortOption.getAttributeName();
            if (!graphElement.hasAttribute(attributeName)) {
                return defaultValue;
            }
            Attribute attribute = graphElement.getAttribute(attributeName);
            return this.resolveAttribute(defaultValue, attribute);
        }
        PositiveGraphDescription attributeNamePath = (PositiveGraphDescription)sortOption.getParameters();
        GraphDescription copy = new GraphDescriptionBuilder().copyWithNewChildren((GraphDescription)context.getLastDescription(), attributeNamePath);
        Object foundSortValue = this.inMemoryGraphLoader.getSearchOptionAttributeValue(graphElement.getId(), (PositiveGraphDescription)copy);
        List<AbstractSearchOptionResolver.SchemaAndCollectionComparisonOperator> collectionComparisonSchema = this.createRelationshipStructureSchema(attributeNamePath, graphElement.getType());
        return this.resolveFoundSortValue(foundSortValue, defaultValue, collectionComparisonSchema);
    }

    private AttributeValue<?> resolveAttribute(AttributeValue<?> defaultValue, Attribute<?> attribute) {
        if (attribute instanceof ListAttribute) {
            ListAttribute listAttribute = (ListAttribute)attribute;
            if (listAttribute.getBoxedValues().isEmpty()) {
                return defaultValue;
            }
            return (AttributeValue)listAttribute.getBoxedValues().get(0);
        }
        if (attribute instanceof SetAttribute) {
            SetAttribute setAttribute = (SetAttribute)attribute;
            if (setAttribute.getBoxedValues().isEmpty()) {
                return defaultValue;
            }
            return (AttributeValue)setAttribute.getBoxedValues().iterator().next();
        }
        return ((LeafAttribute)attribute).getBoxedValue();
    }

    private AttributeValue<?> resolveFoundSortValue(Object sortValue, AttributeValue<?> defaultValue, List<AbstractSearchOptionResolver.SchemaAndCollectionComparisonOperator> collectionComparisonSchema) {
        if (sortValue == null) {
            return defaultValue;
        }
        if (collectionComparisonSchema.isEmpty()) {
            Attribute attribute = (Attribute)sortValue;
            return this.resolveAttribute(defaultValue, attribute);
        }
        List list = (List)sortValue;
        if (list.isEmpty()) {
            return defaultValue;
        }
        int len = collectionComparisonSchema.size();
        List<AbstractSearchOptionResolver.SchemaAndCollectionComparisonOperator> restOfCollectionSchema = collectionComparisonSchema.subList(1, len);
        return this.resolveFoundSortValue(list.get(0), defaultValue, restOfCollectionSchema);
    }
}

