/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.graphLoader.inmemory.filter;

import ai.stapi.graph.attribute.Attribute;
import ai.stapi.graph.attribute.LeafAttribute;
import ai.stapi.graph.attribute.ListAttribute;
import ai.stapi.graph.attribute.SetAttribute;
import ai.stapi.graph.attribute.attributeValue.AttributeValue;
import ai.stapi.graph.attribute.attributeValue.IdAttributeValue;
import ai.stapi.graph.traversableGraphElements.TraversableGraphElement;
import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.graphDescriptionBuilder.GraphDescriptionBuilder;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.PositiveGraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.CollectionComparisonOperator;
import ai.stapi.graphoperations.graphLoader.inmemory.InMemoryGraphLoader;
import ai.stapi.graphoperations.graphLoader.inmemory.InMemorySearchResolvingContext;
import ai.stapi.graphoperations.graphLoader.inmemory.filter.InMemoryFilterResolver;
import ai.stapi.graphoperations.graphLoader.search.AbstractSearchOptionResolver;
import ai.stapi.graphoperations.graphLoader.search.filterOption.FilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.LeafFilterOption;
import ai.stapi.graphoperations.graphLoader.search.filterOption.LeafFilterOptionParameters;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import java.util.List;
import java.util.Set;

public abstract class InMemoryLeafFilterResolver
extends InMemoryFilterResolver {
    private final InMemoryGraphLoader inMemoryGraphLoader;

    protected InMemoryLeafFilterResolver(StructureSchemaFinder structureSchemaFinder, InMemoryGraphLoader inMemoryGraphLoader) {
        super(structureSchemaFinder);
        this.inMemoryGraphLoader = inMemoryGraphLoader;
    }

    public abstract boolean resolve(LeafFilterOption<?> var1, AttributeValue<?> var2);

    protected abstract boolean resolve(LeafFilterOption<?> var1, List<AttributeValue<?>> var2);

    protected abstract boolean resolve(LeafFilterOption<?> var1, Set<AttributeValue<?>> var2);

    @Override
    public boolean resolveElement(FilterOption<?> option, TraversableGraphElement element, InMemorySearchResolvingContext context) {
        LeafFilterOption leafFilterOption = (LeafFilterOption)option;
        if (leafFilterOption.isLeaf()) {
            if (leafFilterOption.isDescribingAttribute()) {
                String attributeName = ((LeafFilterOptionParameters)leafFilterOption.getParameters()).getAttributeName();
                if (!element.hasAttribute(attributeName)) {
                    return this.resolve(leafFilterOption, (AttributeValue)null);
                }
                Attribute attribute = element.getAttribute(attributeName);
                return this.resolveAttribute(leafFilterOption, attribute);
            }
            return this.resolve((LeafFilterOption<?>)leafFilterOption, (AttributeValue<?>)new IdAttributeValue(element.getId().getId()));
        }
        PositiveGraphDescription attributeNamePath = ((LeafFilterOptionParameters)leafFilterOption.getParameters()).getAttributeNamePath();
        GraphDescription copy = new GraphDescriptionBuilder().copyWithNewChildren((GraphDescription)context.getLastDescription(), attributeNamePath);
        Object filterValue = this.inMemoryGraphLoader.getSearchOptionAttributeValue(element.getId(), (PositiveGraphDescription)copy);
        List<AbstractSearchOptionResolver.SchemaAndCollectionComparisonOperator> collectionComparisonSchema = this.createRelationshipStructureSchema(attributeNamePath, element.getType());
        return this.resolveFilterValue(leafFilterOption, filterValue, collectionComparisonSchema);
    }

    private boolean resolveAttribute(LeafFilterOption<?> leafFilterOption, Attribute<?> attribute) {
        if (attribute instanceof ListAttribute) {
            ListAttribute listAttribute = (ListAttribute)attribute;
            return this.resolve(leafFilterOption, listAttribute.getBoxedValues());
        }
        if (attribute instanceof SetAttribute) {
            SetAttribute setAttribute = (SetAttribute)attribute;
            return this.resolve(leafFilterOption, setAttribute.getBoxedValues());
        }
        return this.resolve(leafFilterOption, ((LeafAttribute)attribute).getBoxedValue());
    }

    private boolean resolveFilterValue(LeafFilterOption<?> filterOption, Object filterValue, List<AbstractSearchOptionResolver.SchemaAndCollectionComparisonOperator> collectionComparisonSchema) {
        if (filterValue == null) {
            return this.resolve(filterOption, (AttributeValue)null);
        }
        if (collectionComparisonSchema.isEmpty()) {
            Attribute attribute = (Attribute)filterValue;
            return this.resolveAttribute(filterOption, attribute);
        }
        AbstractSearchOptionResolver.SchemaAndCollectionComparisonOperator currentComparison = collectionComparisonSchema.get(0);
        List list = (List)filterValue;
        int len = collectionComparisonSchema.size();
        List<AbstractSearchOptionResolver.SchemaAndCollectionComparisonOperator> restOfCollectionSchema = collectionComparisonSchema.subList(1, len);
        if (currentComparison.operator().equals((Object)CollectionComparisonOperator.ALL)) {
            return list.stream().allMatch(value -> this.resolveFilterValue(filterOption, value, restOfCollectionSchema));
        }
        if (currentComparison.operator().equals((Object)CollectionComparisonOperator.NONE)) {
            return list.stream().noneMatch(value -> this.resolveFilterValue(filterOption, value, restOfCollectionSchema));
        }
        return list.stream().anyMatch(value -> this.resolveFilterValue(filterOption, value, restOfCollectionSchema));
    }
}

