/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.graphLoader.search;

import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.GraphDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AbstractEdgeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AbstractNodeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.EdgeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.NodeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.CollectionComparisonOperator;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.IngoingEdgeQueryDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.query.OutgoingEdgeQueryDescription;
import ai.stapi.graphoperations.graphLoader.search.ResolvedQueryPart;
import ai.stapi.graphoperations.graphLoader.search.SearchOption;
import ai.stapi.graphoperations.graphLoader.search.SearchOptionResolver;
import ai.stapi.graphoperations.graphLoader.search.SearchResolvingContext;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchemaProvider.StructureSchemaFinder;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSearchOptionResolver<S extends SearchOption<?>, C extends SearchResolvingContext, R extends ResolvedQueryPart>
implements SearchOptionResolver<R> {
    protected final StructureSchemaFinder structureSchemaFinder;

    protected AbstractSearchOptionResolver(StructureSchemaFinder structureSchemaFinder) {
        this.structureSchemaFinder = structureSchemaFinder;
    }

    protected abstract R resolveTyped(S var1, C var2);

    @Override
    public R resolve(SearchOption<?> option, SearchResolvingContext context) {
        return this.resolveTyped(option, context);
    }

    protected List<SchemaAndCollectionComparisonOperator> createRelationshipStructureSchema(GraphDescription attributeNamePath, String graphElementType) {
        ArrayList<SchemaAndCollectionComparisonOperator> result = new ArrayList<SchemaAndCollectionComparisonOperator>();
        GraphDescription graphDescription = attributeNamePath;
        String currentGraphElementType = graphElementType;
        while (!graphDescription.getChildGraphDescriptions().isEmpty()) {
            GraphDescriptionParameters param;
            if (graphDescription instanceof AbstractNodeDescription) {
                AbstractNodeDescription nodeDescription = (AbstractNodeDescription)graphDescription;
                graphDescription = nodeDescription.getChildGraphDescriptions().get(0);
                param = (NodeDescriptionParameters)nodeDescription.getParameters();
                currentGraphElementType = ((NodeDescriptionParameters)param).getNodeType();
                continue;
            }
            if (graphDescription instanceof AbstractEdgeDescription) {
                AbstractEdgeDescription edgeDescription = (AbstractEdgeDescription)graphDescription;
                graphDescription = edgeDescription.getChildGraphDescriptions().get(0);
                param = (EdgeDescriptionParameters)edgeDescription.getParameters();
                FieldDefinition schema = this.structureSchemaFinder.getFieldDefinitionOrFallback(currentGraphElementType, ((EdgeDescriptionParameters)param).getEdgeType());
                currentGraphElementType = ((EdgeDescriptionParameters)param).getEdgeType();
                if (edgeDescription instanceof OutgoingEdgeQueryDescription) {
                    OutgoingEdgeQueryDescription queryDescription = (OutgoingEdgeQueryDescription)edgeDescription;
                    result.add(new SchemaAndCollectionComparisonOperator(schema, queryDescription.getCollectionComparisonOperator()));
                    continue;
                }
                if (edgeDescription instanceof IngoingEdgeQueryDescription) {
                    IngoingEdgeQueryDescription queryDescription = (IngoingEdgeQueryDescription)edgeDescription;
                    result.add(new SchemaAndCollectionComparisonOperator(schema, queryDescription.getCollectionComparisonOperator()));
                    continue;
                }
                result.add(new SchemaAndCollectionComparisonOperator(schema, CollectionComparisonOperator.ANY));
                continue;
            }
            graphDescription = graphDescription.getChildGraphDescriptions().get(0);
        }
        return result;
    }

    public record SchemaAndCollectionComparisonOperator(FieldDefinition fieldDefinition, CollectionComparisonOperator operator) {
    }
}

