/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.graphLoader.search;

import ai.stapi.graphoperations.graphLoader.search.SearchOption;
import ai.stapi.graphoperations.graphLoader.search.SearchQueryParametersBuilder;
import ai.stapi.graphoperations.graphLoader.search.exceptions.SearchOptionResolverRuntimeException;
import ai.stapi.graphoperations.graphLoader.search.filterOption.FilterOption;
import ai.stapi.graphoperations.graphLoader.search.paginationOption.OffsetPaginationOption;
import ai.stapi.graphoperations.graphLoader.search.paginationOption.OffsetPaginationParameters;
import ai.stapi.graphoperations.graphLoader.search.paginationOption.PaginationOption;
import ai.stapi.graphoperations.graphLoader.search.sortOption.SortOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchQueryParameters {
    public static final OffsetPaginationOption DEFAULT_PAGINATION_OPTION = null;
    private final List<FilterOption<?>> filterOptions;
    private final List<SortOption> sortOptions;
    @Nullable
    private final PaginationOption<?> paginationOption;

    public SearchQueryParameters(List<FilterOption<?>> filterOptions, List<SortOption> sortOptions, @Nullable PaginationOption<?> paginationOption) {
        this.sortOptions = sortOptions;
        this.filterOptions = filterOptions;
        this.paginationOption = paginationOption;
    }

    public SearchQueryParameters(List<FilterOption<?>> filterOptions, List<SortOption> sortOptions) {
        this(filterOptions, sortOptions, DEFAULT_PAGINATION_OPTION);
    }

    public SearchQueryParameters() {
        this(new ArrayList(), new ArrayList<SortOption>());
    }

    public static SearchQueryParameters from(SearchOption<?> ... searchOptions) {
        Map initialReduction = Map.ofEntries(Map.entry("paging", new ArrayList()), Map.entry("filter", new ArrayList()), Map.entry("sort", new ArrayList()));
        Map optionMap = Arrays.stream(searchOptions).reduce(initialReduction, SearchQueryParameters::categorizeOption, SearchQueryParameters::mergeMaps);
        int paginationOptionCount = ((List)optionMap.get("paging")).size();
        if (paginationOptionCount > 1) {
            throw SearchOptionResolverRuntimeException.becauseSearchQueryParamatersCanOnlyHaveOnePagingOptions();
        }
        ArrayList filters = new ArrayList();
        ((List)optionMap.get("filter")).stream().map(searchOption -> (FilterOption)searchOption).forEach(filters::add);
        List<SortOption> sorts = ((List)optionMap.get("sort")).stream().map(searchOption -> (SortOption)searchOption).collect(Collectors.toList());
        PaginationOption<OffsetPaginationParameters> paginationOption = paginationOptionCount == 0 ? DEFAULT_PAGINATION_OPTION : (PaginationOption)((List)optionMap.get("paging")).get(0);
        return new SearchQueryParameters(filters, sorts, paginationOption);
    }

    public static SearchQueryParametersBuilder builder() {
        return new SearchQueryParametersBuilder();
    }

    @NotNull
    private static Map<String, List<SearchOption<?>>> categorizeOption(Map<String, List<SearchOption<?>>> stringSearchOptionHashMap, SearchOption<?> searchOption) {
        stringSearchOptionHashMap.get(searchOption.getOptionType()).add(searchOption);
        return stringSearchOptionHashMap;
    }

    @NotNull
    private static Map<String, List<SearchOption<?>>> mergeMaps(Map<String, List<SearchOption<?>>> map1, Map<String, List<SearchOption<?>>> map2) {
        map1.putAll(map2);
        return map1;
    }

    public List<SortOption> getSortOptions() {
        return this.sortOptions;
    }

    public List<FilterOption<?>> getFilterOptions() {
        return this.filterOptions;
    }

    @Nullable
    public PaginationOption<?> getPaginationOption() {
        return this.paginationOption;
    }
}

