/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.graphReader.mappingPartReadResolvers;

import ai.stapi.graph.inMemoryGraph.InMemoryGraphRepository;
import ai.stapi.graph.traversableGraphElements.TraversableEdge;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.AbstractEdgeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.EdgeDescriptionParameters;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.IngoingEdgeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.OutgoingEdgeDescription;
import ai.stapi.graphoperations.graphLanguage.graphDescription.specific.positive.PositiveGraphDescription;
import ai.stapi.graphoperations.graphReader.mappingPartReadResolvers.GraphDescriptionReadResolver;
import ai.stapi.graphoperations.graphReader.mappingPartReadResolvers.exception.GraphDescriptionReadResolverException;
import ai.stapi.graphoperations.graphReader.readResults.EdgeReadResult;
import ai.stapi.graphoperations.graphReader.readResults.NodeReadResult;
import ai.stapi.graphoperations.graphReader.readResults.ReadResult;
import java.util.List;
import java.util.stream.Stream;

public class EdgeDescriptionReadResolver
implements GraphDescriptionReadResolver {
    @Override
    public List<ReadResult> resolve(ReadResult previousResult, PositiveGraphDescription graphDescription, InMemoryGraphRepository context) {
        if (!(previousResult instanceof NodeReadResult)) {
            throw GraphDescriptionReadResolverException.becauseIngoingReadResultIsNotSupported(previousResult, this);
        }
        NodeReadResult nodeReadResult = (NodeReadResult)previousResult;
        EdgeDescriptionParameters parameters = (EdgeDescriptionParameters)graphDescription.getParameters();
        Stream edgeStream = nodeReadResult.getNode().getEdges(parameters.getEdgeType()).stream();
        if (graphDescription instanceof OutgoingEdgeDescription) {
            return edgeStream.filter(traversableEdge -> traversableEdge.getNodeFromId().equals((Object)nodeReadResult.getGraphElement().getId())).map(edge -> new EdgeReadResult((TraversableEdge)edge)).toList();
        }
        if (graphDescription instanceof IngoingEdgeDescription) {
            return edgeStream.filter(traversableEdge -> traversableEdge.getNodeToId().equals((Object)nodeReadResult.getGraphElement().getId())).map(edge -> new EdgeReadResult((TraversableEdge)edge)).toList();
        }
        throw GraphDescriptionReadResolverException.becauseGraphDescriptionTypeIsNotSupported(graphDescription, this);
    }

    @Override
    public boolean supports(PositiveGraphDescription graphDescription) {
        return graphDescription instanceof AbstractEdgeDescription;
    }
}

