/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.graphbuilder.specific.positive;

import ai.stapi.graph.AttributeContainer;
import ai.stapi.graph.Graph;
import ai.stapi.graph.attribute.Attribute;
import ai.stapi.graph.attribute.attributeFactory.GenericAttributeFactory;
import ai.stapi.graph.graphelements.Node;
import ai.stapi.graphoperations.graphbuilder.exception.GraphBuilderException;
import ai.stapi.graphoperations.graphbuilder.specific.positive.AttributeBuilder;
import ai.stapi.graphoperations.graphbuilder.specific.positive.GraphElementBuilder;
import ai.stapi.identity.UniqueIdentifier;
import java.util.ArrayList;
import java.util.List;

public class NodeBuilder
implements GraphElementBuilder {
    private final List<AttributeBuilder> attributes = new ArrayList<AttributeBuilder>();
    private UniqueIdentifier id;
    private String type;

    @Override
    public NodeBuilder setId(UniqueIdentifier id) {
        this.id = id;
        return this;
    }

    public NodeBuilder setId(String id) {
        this.id = new UniqueIdentifier(id);
        return this;
    }

    @Override
    public AttributeBuilder addAttribute() {
        AttributeBuilder attributeBuilder = new AttributeBuilder();
        this.attributes.add(attributeBuilder);
        return attributeBuilder;
    }

    @Override
    public AttributeBuilder getLastAttribute() {
        if (this.attributes.size() == 0) {
            throw GraphBuilderException.becauseThereAreNoAttributesOnElement();
        }
        return this.attributes.get(this.attributes.size() - 1);
    }

    @Override
    public boolean isComplete() {
        return this.id != null && this.type != null;
    }

    public Node build(GenericAttributeFactory attributeFactory) {
        if (!this.isComplete()) {
            throw GraphBuilderException.becauseNodeIsMissingIdOrType();
        }
        Node node = new Node(this.id, this.type);
        for (AttributeBuilder builder : this.attributes) {
            Attribute<?> attribute = builder.build(attributeFactory);
            node = node.add(attribute);
        }
        return node;
    }

    @Override
    public Graph buildToGraph(GenericAttributeFactory attributeFactory) {
        return new Graph(new AttributeContainer[]{this.build(attributeFactory)});
    }

    public String getType() {
        return this.type;
    }

    @Override
    public NodeBuilder setType(String type) {
        this.type = type;
        return this;
    }
}

