/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphoperations.serializableGraph;

import ai.stapi.graphoperations.serializableGraph.SerializableAttributeVersion;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public abstract class SerializableGraphElement {
    private final String id;
    private final String type;
    private final Map<String, List<SerializableAttributeVersion>> attributes;

    protected SerializableGraphElement(String id, String type, Map<String, List<SerializableAttributeVersion>> attributes) {
        this.id = id;
        this.type = type;
        this.attributes = attributes;
    }

    @JsonCreator
    protected SerializableGraphElement(@JsonProperty(value="_id") String reference, @JsonProperty(value="attributes") Map<String, List<SerializableAttributeVersion>> attributes, @JsonProperty(value="_key") String key, @JsonProperty(value="_rev") String revision) {
        String[] split = reference.split("/");
        this.id = split[1];
        this.type = split[0];
        this.attributes = attributes;
    }

    @JsonProperty(value="_id")
    public String getGlobalId() {
        return String.format("%s/%s", this.getType(), this.getId());
    }

    @JsonProperty(value="_key")
    public String getId() {
        return this.id;
    }

    @JsonIgnore
    public String getType() {
        return this.type;
    }

    public Map<String, List<SerializableAttributeVersion>> getAttributes() {
        return this.attributes;
    }
}

