/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.metrics;

import ai.starlake.job.metrics.Metrics;
import ai.starlake.job.metrics.Metrics$CatCountFreq$;
import ai.starlake.job.metrics.Metrics$CountDistinct$;
import ai.starlake.job.metrics.Metrics$CountMissValues$;
import ai.starlake.job.metrics.Metrics$CountMissValuesDiscrete$;
import ai.starlake.job.metrics.Metrics$Kurtosis$;
import ai.starlake.job.metrics.Metrics$Max$;
import ai.starlake.job.metrics.Metrics$Mean$;
import ai.starlake.job.metrics.Metrics$Median$;
import ai.starlake.job.metrics.Metrics$Min$;
import ai.starlake.job.metrics.Metrics$Percentile25$;
import ai.starlake.job.metrics.Metrics$Percentile75$;
import ai.starlake.job.metrics.Metrics$Skewness$;
import ai.starlake.job.metrics.Metrics$Stddev$;
import ai.starlake.job.metrics.Metrics$Sum$;
import ai.starlake.job.metrics.Metrics$Variance$;
import ai.starlake.utils.DataTypeEx$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Metrics$
implements StrictLogging {
    public static final Metrics$ MODULE$;
    private final List<Metrics.ContinuousMetric> continuousMetrics;
    private final List<Metrics.DiscreteMetric> discreteMetrics;
    private final Logger logger;

    static {
        new Metrics$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public List<Metrics.ContinuousMetric> continuousMetrics() {
        return this.continuousMetrics;
    }

    public Column customMetric(Column e, String metricName, Function1<Column, Column> metricFunction) {
        String aliasMetricName = new StringBuilder().append((Object)metricName).append((Object)"(").append((Object)e.toString()).append((Object)")").toString();
        return ((Column)metricFunction.apply((Object)e)).as(aliasMetricName);
    }

    public Column customMean(Column e) {
        return this.customMetric(e, "mean", (Function1<Column, Column>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(Column e) {
                return functions$.MODULE$.mean(e);
            }
        });
    }

    public Column customVariance(Column e) {
        return this.customMetric(e, "variance", (Function1<Column, Column>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(Column e) {
                return functions$.MODULE$.variance(e);
            }
        });
    }

    public Column customStddev(Column e) {
        return this.customMetric(e, "standardDev", (Function1<Column, Column>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(Column e) {
                return functions$.MODULE$.stddev(e);
            }
        });
    }

    public Column customMetricUDF(Column e, String metricName, Function2<String, Seq<Column>, Column> metricFunction, String approxMethod, double approxValue) {
        String aliasMetric = new StringBuilder().append((Object)metricName).append((Object)"(").append((Object)e.toString()).append((Object)")").toString();
        return ((Column)metricFunction.apply((Object)approxMethod, (Object)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{e, functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)approxValue))}))).as(aliasMetric);
    }

    public Column percentile25(Column e) {
        return this.customMetricUDF(e, "percentile25", (Function2<String, Seq<Column>, Column>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(String udfName, Seq<Column> cols) {
                return functions$.MODULE$.callUDF(udfName, cols);
            }
        }, "percentile_approx", 0.25);
    }

    public Column customMedian(Column e) {
        return this.customMetricUDF(e, "median", (Function2<String, Seq<Column>, Column>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(String udfName, Seq<Column> cols) {
                return functions$.MODULE$.callUDF(udfName, cols);
            }
        }, "percentile_approx", 0.5);
    }

    public Column percentile75(Column e) {
        return this.customMetricUDF(e, "percentile75", (Function2<String, Seq<Column>, Column>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(String udfName, Seq<Column> cols) {
                return functions$.MODULE$.callUDF(udfName, cols);
            }
        }, "percentile_approx", 0.75);
    }

    public Column customCountMissValues(Column e) {
        String nameCol = e.toString();
        String aliasCountMissValues = new StringBuilder().append((Object)"missingValues(").append((Object)nameCol).append((Object)")").toString();
        Column unionMissingValues = functions$.MODULE$.sum(functions$.MODULE$.when(e.isNull().$bar$bar((Object)e.$eq$eq$eq((Object)"")), (Object)BoxesRunTime.boxToInteger((int)1)).otherwise((Object)BoxesRunTime.boxToInteger((int)0)));
        return unionMissingValues.as(aliasCountMissValues);
    }

    public Dataset<Row> regroupContinuousMetricsByVariable(String nameCol, Dataset<Row> metricFrame) {
        String[] listColumns = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])metricFrame.columns()).filter((Function1)new Serializable(nameCol){
            public static final long serialVersionUID = 0L;
            private final String nameCol$1;

            public final boolean apply(String x$1) {
                return x$1.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.nameCol$1})));
            }
            {
                this.nameCol$1 = nameCol$1;
            }
        })).sorted((Ordering)Ordering.String$.MODULE$);
        Dataset selectedListColumns = metricFrame.select((String)Predef$.MODULE$.refArrayOps((Object[])listColumns).head(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])listColumns).tail()));
        Dataset broundColumns = selectedListColumns.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])selectedListColumns.columns()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(String c) {
                return functions$.MODULE$.bround(functions$.MODULE$.col(c), 3).alias(c);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
        Dataset addVariablesColumn = broundColumns.withColumn("attribute", functions$.MODULE$.lit((Object)nameCol));
        List removeNameColumnMetric = (List)((List)Predef$.MODULE$.refArrayOps((Object[])addVariablesColumn.columns()).toList().map((Function1)new Serializable(nameCol){
            public static final long serialVersionUID = 0L;
            private final String nameCol$1;

            public final String apply(String str) {
                return str.replaceAll(new StringBuilder().append((Object)"\\(").append((Object)this.nameCol$1).append((Object)"\\)").toString(), "");
            }
            {
                this.nameCol$1 = nameCol$1;
            }
        }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).capitalize();
            }
        }, List$.MODULE$.canBuildFrom());
        return addVariablesColumn.toDF((Seq)removeNameColumnMetric);
    }

    private List<String> extractMetricsAttributes(Dataset<Row> dataset, List<String> continuousAttributes) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        List datasetAttributes = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])dataset.schema().fields()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$3) {
                return DataTypeEx$.MODULE$.DataTypeEx(x$3.dataType()).isOfValidContinuousType();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$4) {
                return x$4.name();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toList();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Valid Continuous datasetAttributes Attrs ={}", new Object[]{datasetAttributes});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        List intersectionAttributes = (List)datasetAttributes.intersect(continuousAttributes);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Valid intersectionAttributes Attrs ={}", new Object[]{intersectionAttributes});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return intersectionAttributes.nonEmpty() ? intersectionAttributes : Nil$.MODULE$;
    }

    public Option<Dataset<Row>> computeContinuousMetric(Dataset<Row> dataset, List<String> continuousAttributes, List<Metrics.ContinuousMetric> operations) {
        None$ none$;
        BoxedUnit boxedUnit;
        List<String> attributeChecked = this.extractMetricsAttributes(dataset, continuousAttributes);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Continuous attributes : {}", new Object[]{attributeChecked});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String string = "attribute";
        List colRenamed = ((List)operations.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Metrics.ContinuousMetric x$5) {
                return x$5.name();
            }
        }, List$.MODULE$.canBuildFrom())).$colon$colon((Object)string);
        List metrics = (List)attributeChecked.flatMap((Function1)new Serializable(operations){
            public static final long serialVersionUID = 0L;
            private final List operations$1;

            public final List<Column> apply(String name2) {
                return (List)this.operations$1.map((Function1)new Serializable(this, name2){
                    public static final long serialVersionUID = 0L;
                    private final String name$1;

                    public final Column apply(Metrics.ContinuousMetric metric) {
                        return (Column)metric.function().apply((Object)functions$.MODULE$.col(this.name$1));
                    }
                    {
                        this.name$1 = name$1;
                    }
                }, List$.MODULE$.canBuildFrom());
            }
            {
                this.operations$1 = operations$1;
            }
        }, List$.MODULE$.canBuildFrom());
        List dropAttributes = (List)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])dataset.schema().fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$7) {
                return x$7.name();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toList().filterNot((Function1)continuousAttributes.toSet());
        List list = metrics;
        if (Nil$.MODULE$.equals(list)) {
            none$ = None$.MODULE$;
        } else {
            Dataset droppedDataset = dataset.drop((Seq)dropAttributes);
            Dataset metricFrame = droppedDataset.agg((Column)metrics.head(), (Seq)metrics.tail());
            Dataset matrixMetric = (Dataset)((TraversableOnce)attributeChecked.map((Function1)new Serializable(metricFrame){
                public static final long serialVersionUID = 0L;
                private final Dataset metricFrame$1;

                public final Dataset<Row> apply(String x) {
                    return Metrics$.MODULE$.regroupContinuousMetricsByVariable(x, (Dataset<Row>)this.metricFrame$1);
                }
                {
                    this.metricFrame$1 = metricFrame$1;
                }
            }, List$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Dataset<Row> apply(Dataset<Row> x$8, Dataset<Row> x$9) {
                    return x$8.union(x$9);
                }
            });
            Dataset res = matrixMetric.select((String)colRenamed.head(), (Seq)colRenamed.tail()).withColumn("cometMetric", functions$.MODULE$.lit((Object)"Continuous"));
            none$ = new Some((Object)res);
        }
        return none$;
    }

    public List<Metrics.DiscreteMetric> discreteMetrics() {
        return this.discreteMetrics;
    }

    public Dataset<Row> dataToMetricData(Tuple2<Column, Dataset<Row>> colNamDataCatCountFreq, List<Metrics.DiscreteMetric> operations) {
        Tuple2<Column, Dataset<Row>> tuple2 = colNamDataCatCountFreq;
        if (tuple2 != null) {
            Tuple2 tuple22;
            Column colVar = (Column)tuple2._1();
            Dataset dataCatCountFreq = (Dataset)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)colVar, (Object)dataCatCountFreq);
            Column colVar2 = (Column)tuple23._1();
            Dataset dataCatCountFreq2 = (Dataset)tuple23._2();
            List listCol = (List)operations.map((Function1)new Serializable(colVar2, dataCatCountFreq2){
                public static final long serialVersionUID = 0L;
                private final Column colVar$1;
                private final Dataset dataCatCountFreq$1;

                public final Column apply(Metrics.DiscreteMetric metric) {
                    return (Column)metric.function().apply((Object)new Tuple2((Object)this.colVar$1, (Object)this.dataCatCountFreq$1));
                }
                {
                    this.colVar$1 = colVar$1;
                    this.dataCatCountFreq$1 = dataCatCountFreq$1;
                }
            }, List$.MODULE$.canBuildFrom());
            return dataCatCountFreq2.withColumn("cat_count_freq", functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("Category").cast((DataType)StringType$.MODULE$).as("category"), functions$.MODULE$.col("CountDiscrete").cast((DataType)LongType$.MODULE$).as("countDiscrete"), functions$.MODULE$.col("Frequencies").cast((DataType)DoubleType$.MODULE$).as("frequency")}))).agg((Column)listCol.head(), (Seq)listCol.tail()).withColumn("attribute", functions$.MODULE$.lit((Object)colVar2.toString()));
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<Column, Dataset<Row>> categoryCountFreqDataframe(Column e, Dataset<Row> dataInit) {
        Dataset dataCatCount = dataInit.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{e})).count().toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Category", "CountDiscrete"}));
        long sumValues = dataInit.count();
        Dataset dataCatCountFreq = dataCatCount.withColumn("Frequencies", functions$.MODULE$.bround(dataCatCount.apply("CountDiscrete").$div((Object)BoxesRunTime.boxToLong((long)sumValues)), 3)).withColumn("NumMissVals", functions$.MODULE$.when(functions$.MODULE$.col("Category").isNotNull(), (Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)0))).otherwise((Object)functions$.MODULE$.col("CountDiscrete"))).withColumn("CategoryChange", functions$.MODULE$.col("Category"));
        return new Tuple2((Object)e, (Object)dataCatCountFreq);
    }

    public Column metricCategory(Dataset<Row> dataCategoryCount) {
        return functions$.MODULE$.collect_list(functions$.MODULE$.col("Category"));
    }

    public Column metricCountDiscret(Dataset<Row> dataCategoryCount) {
        return functions$.MODULE$.collect_list(functions$.MODULE$.map((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("CategoryChange"), functions$.MODULE$.col("CountDiscrete")}))).as("countByCategory");
    }

    public Column metricFrequency(Dataset<Row> dataCategoryCount) {
        return functions$.MODULE$.collect_list(functions$.MODULE$.map((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("CategoryChange"), functions$.MODULE$.col("Frequencies")}))).as("frequencies");
    }

    public Column metricCountDistinct(Dataset<Row> dataCategoryCount) {
        return functions$.MODULE$.count(functions$.MODULE$.col("Category"));
    }

    public Column metricCatCountFreq(Dataset<Row> dataCategoryCount) {
        return functions$.MODULE$.collect_list(functions$.MODULE$.col("cat_count_freq")).as("catCountFreq");
    }

    public Column metricMissingValues(Dataset<Row> dataCategoryCount) {
        return functions$.MODULE$.sum(functions$.MODULE$.col("NumMissVals"));
    }

    public Column customMetricDiscret(Column e, Dataset<Row> dataCategoryCount, String metricName, Function1<Dataset<Row>, Column> metricFunction) {
        String aliasMetricName = metricName;
        return ((Column)metricFunction.apply(dataCategoryCount)).as(aliasMetricName);
    }

    public Column customCategory(Tuple2<Column, Dataset<Row>> colNameDataCatCount) {
        Tuple2<Column, Dataset<Row>> tuple2 = colNameDataCatCount;
        if (tuple2 != null) {
            Tuple2 tuple22;
            Column colVar = (Column)tuple2._1();
            Dataset dataCatCount = (Dataset)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)colVar, (Object)dataCatCount);
            Column colVar2 = (Column)tuple23._1();
            Dataset dataCatCount2 = (Dataset)tuple23._2();
            return this.customMetricDiscret(colVar2, (Dataset<Row>)dataCatCount2, "category", (Function1<Dataset<Row>, Column>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Column apply(Dataset<Row> dataCategoryCount) {
                    return Metrics$.MODULE$.metricCategory(dataCategoryCount);
                }
            });
        }
        throw new MatchError(tuple2);
    }

    public Column customCountDistinct(Tuple2<Column, Dataset<Row>> colNameDataCatCount) {
        Tuple2<Column, Dataset<Row>> tuple2 = colNameDataCatCount;
        if (tuple2 != null) {
            Tuple2 tuple22;
            Column colVar = (Column)tuple2._1();
            Dataset dataCatCount = (Dataset)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)colVar, (Object)dataCatCount);
            Column colVar2 = (Column)tuple23._1();
            Dataset dataCatCount2 = (Dataset)tuple23._2();
            return this.customMetricDiscret(colVar2, (Dataset<Row>)dataCatCount2, "countDistinct", (Function1<Dataset<Row>, Column>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Column apply(Dataset<Row> dataCategoryCount) {
                    return Metrics$.MODULE$.metricCountDistinct(dataCategoryCount);
                }
            });
        }
        throw new MatchError(tuple2);
    }

    public Column customCatCountFreq(Tuple2<Column, Dataset<Row>> colNameDataCatCount) {
        Tuple2<Column, Dataset<Row>> tuple2 = colNameDataCatCount;
        if (tuple2 != null) {
            Tuple2 tuple22;
            Column colVar = (Column)tuple2._1();
            Dataset dataCatCount = (Dataset)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)colVar, (Object)dataCatCount);
            Column colVar2 = (Column)tuple23._1();
            Dataset dataCatCount2 = (Dataset)tuple23._2();
            return this.customMetricDiscret(colVar2, (Dataset<Row>)dataCatCount2, "catCountFreq", (Function1<Dataset<Row>, Column>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Column apply(Dataset<Row> dataCategoryCount) {
                    return Metrics$.MODULE$.metricCatCountFreq(dataCategoryCount);
                }
            });
        }
        throw new MatchError(tuple2);
    }

    public Column customCountDiscrete(Tuple2<Column, Dataset<Row>> colNameDataCatCount) {
        Tuple2<Column, Dataset<Row>> tuple2 = colNameDataCatCount;
        if (tuple2 != null) {
            Tuple2 tuple22;
            Column colVar = (Column)tuple2._1();
            Dataset dataCatCount = (Dataset)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)colVar, (Object)dataCatCount);
            Column colVar2 = (Column)tuple23._1();
            Dataset dataCatCount2 = (Dataset)tuple23._2();
            return this.customMetricDiscret(colVar2, (Dataset<Row>)dataCatCount2, "countByCategory", (Function1<Dataset<Row>, Column>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Column apply(Dataset<Row> dataCategoryCount) {
                    return Metrics$.MODULE$.metricCountDiscret(dataCategoryCount);
                }
            });
        }
        throw new MatchError(tuple2);
    }

    public Column customFrequencies(Tuple2<Column, Dataset<Row>> colNameDataCatCount) {
        Tuple2<Column, Dataset<Row>> tuple2 = colNameDataCatCount;
        if (tuple2 != null) {
            Tuple2 tuple22;
            Column colVar = (Column)tuple2._1();
            Dataset dataCatCount = (Dataset)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)colVar, (Object)dataCatCount);
            Column colVar2 = (Column)tuple23._1();
            Dataset dataCatCount2 = (Dataset)tuple23._2();
            return this.customMetricDiscret(colVar2, (Dataset<Row>)dataCatCount2, "frequencies", (Function1<Dataset<Row>, Column>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Column apply(Dataset<Row> dataCategoryCount) {
                    return Metrics$.MODULE$.metricFrequency(dataCategoryCount);
                }
            });
        }
        throw new MatchError(tuple2);
    }

    public Column customCountMissValuesDiscrete(Tuple2<Column, Dataset<Row>> colNameDataCatCount) {
        Tuple2<Column, Dataset<Row>> tuple2 = colNameDataCatCount;
        if (tuple2 != null) {
            Tuple2 tuple22;
            Column colVar = (Column)tuple2._1();
            Dataset dataCatCount = (Dataset)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)colVar, (Object)dataCatCount);
            Column colVar2 = (Column)tuple23._1();
            Dataset dataCatCount2 = (Dataset)tuple23._2();
            return this.customMetricDiscret(colVar2, (Dataset<Row>)dataCatCount2, "missingValuesDiscrete", (Function1<Dataset<Row>, Column>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Column apply(Dataset<Row> dataCategoryCount) {
                    return Metrics$.MODULE$.metricMissingValues(dataCategoryCount);
                }
            });
        }
        throw new MatchError(tuple2);
    }

    public Option<Dataset<Row>> computeDiscretMetric(Dataset<Row> dataInit, List<String> discreteAttrs2, List<Metrics.DiscreteMetric> operations) {
        None$ none$;
        BoxedUnit boxedUnit;
        List attributeChecked;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        List headerDataUse = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])dataInit.schema().fields()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$17) {
                return DataTypeEx$.MODULE$.DataTypeEx(x$17.dataType()).isOfValidDiscreteType();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$18) {
                return x$18.name();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toList();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"Discrete Headers -> ").append((Object)headerDataUse.mkString(",")).toString());
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        List intersectionHeaderAttributes = (List)headerDataUse.intersect(discreteAttrs2);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"intersectionHeaderAttributes Headers -> ").append((Object)intersectionHeaderAttributes.mkString(",")).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        String[] dropAttributes = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])dataInit.schema().fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$19) {
                return x$19.name();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filterNot((Function1)discreteAttrs2.toSet());
        Object object = attributeChecked = intersectionHeaderAttributes.nonEmpty() ? intersectionHeaderAttributes : Nil$.MODULE$;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"attributeChecked Headers -> ").append((Object)attributeChecked.mkString(",")).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        List list = attributeChecked;
        if (Nil$.MODULE$.equals(list)) {
            none$ = None$.MODULE$;
        } else {
            Dataset dataset = dataInit.drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])dropAttributes));
            String string = "attribute";
            List colRenamed = ((List)operations.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Metrics.DiscreteMetric x$20) {
                    return x$20.name();
                }
            }, List$.MODULE$.canBuildFrom())).$colon$colon((Object)string);
            Dataset matrixMetric = (Dataset)((TraversableOnce)((List)attributeChecked.map((Function1)new Serializable(dataset){
                public static final long serialVersionUID = 0L;
                private final Dataset dataset$1;

                public final Tuple2<Column, Dataset<Row>> apply(String name2) {
                    return Metrics$.MODULE$.categoryCountFreqDataframe(functions$.MODULE$.col(name2), (Dataset<Row>)this.dataset$1);
                }
                {
                    this.dataset$1 = dataset$1;
                }
            }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(operations){
                public static final long serialVersionUID = 0L;
                private final List operations$2;

                public final Dataset<Row> apply(Tuple2<Column, Dataset<Row>> colData) {
                    return Metrics$.MODULE$.dataToMetricData(colData, (List<Metrics.DiscreteMetric>)this.operations$2);
                }
                {
                    this.operations$2 = operations$2;
                }
            }, List$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Dataset<Row> apply(Dataset<Row> x$22, Dataset<Row> x$23) {
                    return x$22.union(x$23);
                }
            });
            Dataset res = matrixMetric.select((String)colRenamed.head(), (Seq)colRenamed.tail()).withColumn("cometMetric", functions$.MODULE$.lit((Object)"Discrete"));
            none$ = new Some((Object)res);
        }
        return none$;
    }

    private Metrics$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.continuousMetrics = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Metrics.ContinuousMetric[]{Metrics$Min$.MODULE$, Metrics$Max$.MODULE$, Metrics$Mean$.MODULE$, Metrics$CountMissValues$.MODULE$, Metrics$Variance$.MODULE$, Metrics$Stddev$.MODULE$, Metrics$Sum$.MODULE$, Metrics$Skewness$.MODULE$, Metrics$Kurtosis$.MODULE$, Metrics$Percentile25$.MODULE$, Metrics$Median$.MODULE$, Metrics$Percentile75$.MODULE$}));
        this.discreteMetrics = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Metrics.DiscreteMetric[]{Metrics$CountDistinct$.MODULE$, Metrics$CatCountFreq$.MODULE$, Metrics$CountMissValuesDiscrete$.MODULE$}));
    }
}

