/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.sink.bigquery;

import ai.starlake.job.sink.bigquery.BigQueryJobBase$;
import ai.starlake.utils.Utils$;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.cloud.bigquery.ViewDefinition;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.util.List;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class BigQueryNativeJob$
implements StrictLogging {
    public static final BigQueryNativeJob$ MODULE$;
    private final Logger logger;

    static {
        new BigQueryNativeJob$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void createTable(String datasetName, String tableName, Schema schema) {
        Try try_;
        block7: {
            block6: {
                BoxedUnit boxedUnit;
                block5: {
                    try_ = Try$.MODULE$.apply((Function0)new Serializable(datasetName, tableName, schema){
                        public static final long serialVersionUID = 0L;
                        private final String datasetName$1;
                        private final String tableName$1;
                        private final Schema schema$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            Some some;
                            Table tbl;
                            TableId tableId = TableId.of((String)this.datasetName$1, (String)this.tableName$1);
                            Option table = Option$.MODULE$.apply((Object)BigQueryJobBase$.MODULE$.bigquery().getTable(tableId, new BigQuery.TableOption[0]));
                            Option option2 = table;
                            if (option2 instanceof Some && (tbl = (Table)(some = (Some)option2).x()).exists()) {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                BoxedUnit boxedUnit;
                                StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)this.schema$1);
                                TableInfo tableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)tableDefinition).build();
                                BigQueryJobBase$.MODULE$.bigquery().create(tableInfo, new BigQuery.TableOption[0]);
                                if (BigQueryNativeJob$.MODULE$.logger().underlying().isInfoEnabled()) {
                                    BigQueryNativeJob$.MODULE$.logger().underlying().info("Table {}.{} created successfully", new Object[]{this.datasetName$1, this.tableName$1});
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit2 = boxedUnit;
                            }
                        }
                        {
                            this.datasetName$1 = datasetName$1;
                            this.tableName$1 = tableName$1;
                            this.schema$1 = schema$1;
                        }
                    });
                    if (!(try_ instanceof Success)) break block5;
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    break block6;
                }
                if (!(try_ instanceof Failure)) break block7;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Table {}.{} was not created.", new Object[]{datasetName, tableName});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Utils$.MODULE$.logException(this.logger(), e);
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)try_);
    }

    public void createViews(Map<String, String> views, Option<String> udf) {
        views.foreach((Function1)new Serializable(udf){
            public static final long serialVersionUID = 0L;
            private final Option udf$1;

            public final void apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    ViewDefinition.Builder viewQuery = ViewDefinition.newBuilder((String)value).setUseLegacySql(Predef$.MODULE$.boolean2Boolean(false));
                    ViewDefinition.Builder viewDefinition = (ViewDefinition.Builder)this.udf$1.map((Function1)new Serializable(this, viewQuery){
                        public static final long serialVersionUID = 0L;
                        private final ViewDefinition.Builder viewQuery$1;

                        public final ViewDefinition.Builder apply(String udf) {
                            return this.viewQuery$1.setUserDefinedFunctions((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UserDefinedFunction[]{UserDefinedFunction.fromUri((String)udf)}))).asJava());
                        }
                        {
                            this.viewQuery$1 = viewQuery$1;
                        }
                    }).getOrElse((Function0)new Serializable(this, viewQuery){
                        public static final long serialVersionUID = 0L;
                        private final ViewDefinition.Builder viewQuery$1;

                        public final ViewDefinition.Builder apply() {
                            return this.viewQuery$1;
                        }
                        {
                            this.viewQuery$1 = viewQuery$1;
                        }
                    });
                    TableId tableId = BigQueryJobBase$.MODULE$.extractProjectDatasetAndTable(key);
                    Option viewRef = Option$.MODULE$.apply((Object)BigQueryJobBase$.MODULE$.bigquery().getTable(tableId, new BigQuery.TableOption[0]));
                    if (viewRef.isEmpty()) {
                        BoxedUnit boxedUnit2;
                        if (BigQueryNativeJob$.MODULE$.logger().underlying().isInfoEnabled()) {
                            BigQueryNativeJob$.MODULE$.logger().underlying().info("View {} does not exist, creating it!", new Object[]{tableId});
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        BigQueryJobBase$.MODULE$.bigquery().create(TableInfo.of((TableId)tableId, (TableDefinition)viewDefinition.build()), new BigQuery.TableOption[0]);
                        if (BigQueryNativeJob$.MODULE$.logger().underlying().isInfoEnabled()) {
                            BigQueryNativeJob$.MODULE$.logger().underlying().info("View {} created", new Object[]{tableId});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else if (BigQueryNativeJob$.MODULE$.logger().underlying().isInfoEnabled()) {
                        BigQueryNativeJob$.MODULE$.logger().underlying().info("View {} already exist", new Object[]{tableId});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.udf$1 = udf$1;
            }
        });
    }

    private BigQueryNativeJob$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
    }
}

