/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.job.sink.http;

import ai.starlake.job.sink.http.HttpSinkClient;
import ai.starlake.job.sink.http.SinkTransformer;
import ai.starlake.utils.Utils$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.execution.streaming.Sink;
import scala.Function0;
import scala.MatchError;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001\u001b\tI\u0001\n\u001e;uaNKgn\u001b\u0006\u0003\u0007\u0011\tA\u0001\u001b;ua*\u0011QAB\u0001\u0005g&t7N\u0003\u0002\b\u0011\u0005\u0019!n\u001c2\u000b\u0005%Q\u0011\u0001C:uCJd\u0017m[3\u000b\u0003-\t!!Y5\u0004\u0001M!\u0001A\u0004\f'!\tyA#D\u0001\u0011\u0015\t\t\"#\u0001\u0003mC:<'\"A\n\u0002\t)\fg/Y\u0005\u0003+A\u0011aa\u00142kK\u000e$\bCA\f%\u001b\u0005A\"BA\r\u001b\u0003%\u0019HO]3b[&twM\u0003\u0002\u001c9\u0005IQ\r_3dkRLwN\u001c\u0006\u0003;y\t1a]9m\u0015\ty\u0002%A\u0003ta\u0006\u00148N\u0003\u0002\"E\u00051\u0011\r]1dQ\u0016T\u0011aI\u0001\u0004_J<\u0017BA\u0013\u0019\u0005\u0011\u0019\u0016N\\6\u0011\u0005\u001drS\"\u0001\u0015\u000b\u0005%R\u0013\u0001D:dC2\fGn\\4hS:<'BA\u0016-\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0017\u0002\u0007\r|W.\u0003\u00020Q\ti1\u000b\u001e:jGRdunZ4j]\u001eD\u0001\"\r\u0001\u0003\u0002\u0003\u0006IAM\u0001\u0004kJd\u0007CA\u001a:\u001d\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0003\u0019\u0001&/\u001a3fM&\u0011!h\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a*\u0004\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \u0002\u00175\f\u00070T3tg\u0006<Wm\u001d\t\u0003i}J!\u0001Q\u001b\u0003\u0007%sG\u000f\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003?\u0003)qW/\u001c*fiJLWm\u001d\u0005\t\t\u0002\u0011\t\u0011)A\u0005}\u0005i!/\u001a;ss&sG/\u001a:wC2D\u0001B\u0012\u0001\u0003\u0002\u0003\u0006IaR\u0001\fiJ\fgn\u001d4pe6,'\u000f\u0005\u0002I\u00136\t!!\u0003\u0002K\u0005\ty1+\u001b8l)J\fgn\u001d4pe6,'\u000fC\u0003M\u0001\u0011\u0005Q*\u0001\u0004=S:LGO\u0010\u000b\u0007\u001d>\u0003\u0016KU*\u0011\u0005!\u0003\u0001\"B\u0019L\u0001\u0004\u0011\u0004\"B\u001fL\u0001\u0004q\u0004\"\u0002\"L\u0001\u0004q\u0004\"\u0002#L\u0001\u0004q\u0004\"\u0002$L\u0001\u00049\u0005bB+\u0001\u0005\u0004%\tAV\u0001\u0007G2LWM\u001c;\u0016\u0003]\u0003\"\u0001\u0013-\n\u0005e\u0013!A\u0004%uiB\u001c\u0016N\\6DY&,g\u000e\u001e\u0005\u00077\u0002\u0001\u000b\u0011B,\u0002\u000f\rd\u0017.\u001a8uA!)Q\f\u0001C!=\u0006A\u0011\r\u001a3CCR\u001c\u0007\u000eF\u0002`E\u001e\u0004\"\u0001\u000e1\n\u0005\u0005,$\u0001B+oSRDQa\u0019/A\u0002\u0011\fqAY1uG\"LE\r\u0005\u00025K&\u0011a-\u000e\u0002\u0005\u0019>tw\rC\u0003i9\u0002\u0007\u0011.\u0001\u0003eCR\f\u0007C\u00016y\u001d\tYgO\u0004\u0002mk:\u0011Q\u000e\u001e\b\u0003]Nt!a\u001c:\u000e\u0003AT!!\u001d\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0013BA\u0011#\u0013\ty\u0002%\u0003\u0002\u001e=%\u0011q\u000fH\u0001\ba\u0006\u001c7.Y4f\u0013\tI(PA\u0005ECR\fgI]1nK*\u0011q\u000f\b")
public class HtttpSink
implements Sink,
StrictLogging {
    private final int numRetries;
    private final int retryInterval;
    private final HttpSinkClient client;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public HttpSinkClient client() {
        return this.client;
    }

    public void addBatch(long batchId, Dataset<Row> data) {
        BooleanRef success = BooleanRef.create((boolean)false);
        IntRef retried = IntRef.create((int)0);
        while (!success.elem && retried.elem < this.numRetries) {
            BoxedUnit boxedUnit;
            Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this, data, success, retried){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HtttpSink $outer;
                private final Dataset data$1;
                private final BooleanRef success$1;
                private final IntRef retried$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    ++this.retried$1.elem;
                    this.$outer.client().send((Dataset<Row>)this.data$1);
                    this.success$1.elem = true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.data$1 = data$1;
                    this.success$1 = success$1;
                    this.retried$1 = retried$1;
                }
            });
            if (try_ instanceof Failure) {
                BoxedUnit boxedUnit2;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                success.elem = false;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(Utils$.MODULE$.exceptionAsString(e));
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (retried.elem < this.numRetries) {
                    BoxedUnit boxedUnit3;
                    int sleepTime = this.retryInterval * retried.elem;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("will retry to send after {}ms", new Object[]{BoxesRunTime.boxToInteger((int)sleepTime)});
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    Thread.sleep(sleepTime);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw e;
            }
            if (try_ instanceof Success) {
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError((Object)try_);
        }
    }

    public HtttpSink(String url, int maxMessages, int numRetries, int retryInterval, SinkTransformer transformer) {
        this.numRetries = numRetries;
        this.retryInterval = retryInterval;
        StrictLogging.class.$init$((StrictLogging)this);
        this.client = new HttpSinkClient(url, maxMessages, transformer);
    }
}

