/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.utils;

import ai.starlake.schema.handlers.StorageHandler;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0001\u0003\u0001%\u0011\u0001BR5mK2{7m\u001b\u0006\u0003\u0007\u0011\tQ!\u001e;jYNT!!\u0002\u0004\u0002\u0011M$\u0018M\u001d7bW\u0016T\u0011aB\u0001\u0003C&\u001c\u0001aE\u0002\u0001\u0015A\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007CA\t\u0019\u001b\u0005\u0011\"BA\n\u0015\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t)b#\u0001\u0005usB,7/\u00194f\u0015\u00059\u0012aA2p[&\u0011\u0011D\u0005\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\t\u0011m\u0001!\u0011!Q\u0001\nq\tA\u0001]1uQB\u0011QDJ\u0007\u0002=)\u0011q\u0004I\u0001\u0003MNT!!\t\u0012\u0002\r!\fGm\\8q\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\n\u0005\u001dr\"\u0001\u0002)bi\"D\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\u000fgR|'/Y4f\u0011\u0006tG\r\\3s!\tY\u0003'D\u0001-\u0015\tic&\u0001\u0005iC:$G.\u001a:t\u0015\tyC!\u0001\u0004tG\",W.Y\u0005\u0003c1\u0012ab\u0015;pe\u0006<W\rS1oI2,'\u000fC\u00034\u0001\u0011\u0005A'\u0001\u0004=S:LGO\u0010\u000b\u0004k]B\u0004C\u0001\u001c\u0001\u001b\u0005\u0011\u0001\"B\u000e3\u0001\u0004a\u0002\"B\u00153\u0001\u0004Q\u0003\"\u0002\u001e\u0001\t\u0003Y\u0014!D2iK\u000e\\\u0017N\u001c)fe&|G-F\u0001=!\tYQ(\u0003\u0002?\u0019\t!Aj\u001c8h\u0011\u0015\u0001\u0005\u0001\"\u0001<\u00035\u0011XM\u001a:fg\"\u0004VM]5pI\"9!\t\u0001b\u0001\n\u0013\u0019\u0015a\u00034jY\u0016<\u0016\r^2iKJ,\u0012\u0001\u0012\t\u0003\u000b6s!A\u000e$\b\u000b\u001d\u0013\u0001\u0012\u0001%\u0002\u0011\u0019KG.\u001a'pG.\u0004\"AN%\u0007\u000b\u0005\u0011\u0001\u0012\u0001&\u0014\u0005%S\u0001\"B\u001aJ\t\u0003aE#\u0001%\u0007\t9KEa\u0014\u0002\f\u0019>\u001c7nV1uG\",'o\u0005\u0003N!b\u0003\u0002CA)W\u001b\u0005\u0011&BA*U\u0003\u0011a\u0017M\\4\u000b\u0003U\u000bAA[1wC&\u0011qK\u0015\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005EK\u0016B\u0001.S\u0005!\u0011VO\u001c8bE2,\u0007\u0002C\u000eN\u0005\u0003\u0005\u000b\u0011\u0002\u000f\t\u0011%j%\u0011!Q\u0001\n)B\u0001BX'\u0003\u0002\u0003\u0006I\u0001P\u0001\u0010e\u0016\u0004xN\u001d;j]\u001e\u0004VM]5pI\")1'\u0014C\u0001AR!\u0011m\u00193f!\t\u0011W*D\u0001J\u0011\u0015Yr\f1\u0001\u001d\u0011\u0015Is\f1\u0001+\u0011\u0015qv\f1\u0001=\u0011\u001d9WJ1A\u0005\n!\f\u0001\u0002\u001d:jgRLg.Z\u000b\u0002SB\u0011!.]\u0007\u0002W*\u0011A.\\\u0001\u0007CR|W.[2\u000b\u00059|\u0017AC2p]\u000e,(O]3oi*\u0011\u0001\u000fV\u0001\u0005kRLG.\u0003\u0002sW\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:Da\u0001^'!\u0002\u0013I\u0017!\u00039sSN$\u0018N\\3!\u0011\u00151X\n\"\u0001x\u00035\u0019\u0007.Z2l!JL7\u000f^5oKR\t\u0001\u0010\u0005\u0002\fs&\u0011!\u0010\u0004\u0002\u0005+:LG\u000fC\u0004}\u001b\n\u0007I\u0011\u00025\u0002\u000bM\u0004XM\u001c;\t\ryl\u0005\u0015!\u0003j\u0003\u0019\u0019\b/\u001a8uA!I\u0011\u0011A'C\u0002\u0013%\u00111A\u0001\u0004g\u0016lWCAA\u0003!\u0011\t9!!\u0003\u000e\u00035L1!a\u0003n\u0005%\u0019V-\\1qQ>\u0014X\r\u0003\u0005\u0002\u00105\u0003\u000b\u0011BA\u0003\u0003\u0011\u0019X-\u001c\u0011\t\r\u0005MQ\n\"\u0001x\u0003\u001d\u0011X\r\\3bg\u0016Da!a\u0006N\t\u0003:\u0018a\u0001:v]\"9\u00111\u0004\u0001!\u0002\u0013!\u0015\u0001\u00044jY\u0016<\u0016\r^2iKJ\u0004\u0003bBA\u0010\u0001\u0011\u0005\u0011\u0011E\u0001\u000fiJLX\t_2mkNLg/\u001a7z+\u0011\t\u0019#!\u000e\u0015\t\u0005\u0015\u0012\u0011\u000b\u000b\u0005\u0003O\t9\u0005\u0005\u0004\u0002*\u00055\u0012\u0011G\u0007\u0003\u0003WQ!\u0001\u001d\u0007\n\t\u0005=\u00121\u0006\u0002\u0004)JL\b\u0003BA\u001a\u0003ka\u0001\u0001\u0002\u0005\u00028\u0005u!\u0019AA\u001d\u0005\u0005!\u0016\u0003BA\u001e\u0003\u0003\u00022aCA\u001f\u0013\r\ty\u0004\u0004\u0002\b\u001d>$\b.\u001b8h!\rY\u00111I\u0005\u0004\u0003\u000bb!aA!os\"I\u0011\u0011JA\u000f\t\u0003\u0007\u00111J\u0001\u0003_B\u0004RaCA'\u0003cI1!a\u0014\r\u0005!a$-\u001f8b[\u0016t\u0004\"CA*\u0003;\u0001\n\u00111\u0001=\u0003=!\u0018.\\3pkRLe.T5mY&\u001c\bbBA,\u0001\u0011\u0005\u0011\u0011L\u0001\u000eI>,\u0005p\u00197vg&4X\r\\=\u0016\t\u0005m\u0013\u0011\r\u000b\u0005\u0003;\n9\u0007\u0006\u0003\u0002`\u0005\r\u0004\u0003BA\u001a\u0003C\"\u0001\"a\u000e\u0002V\t\u0007\u0011\u0011\b\u0005\n\u0003\u0013\n)\u0006\"a\u0001\u0003K\u0002RaCA'\u0003?B\u0011\"a\u0015\u0002VA\u0005\t\u0019\u0001\u001f\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n\u00059AO]=M_\u000e\\G\u0003BA8\u0003k\u00022aCA9\u0013\r\t\u0019\b\u0004\u0002\b\u0005>|G.Z1o\u0011%\t\u0019&!\u001b\u0011\u0002\u0003\u0007A\b\u0003\u0004\u0002\u0014\u0001!\ta\u001e\u0005\u0007\u0003w\u0002A\u0011B<\u0002\u000b]\fGo\u00195\t\u0013\u0005}\u0004!%A\u0005\u0002\u0005\u0005\u0015a\u00063p\u000bb\u001cG.^:jm\u0016d\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0011\t\u0019)!'\u0016\u0005\u0005\u0015%f\u0001\u001f\u0002\b.\u0012\u0011\u0011\u0012\t\u0005\u0003\u0017\u000b)*\u0004\u0002\u0002\u000e*!\u0011qRAI\u0003%)hn\u00195fG.,GMC\u0002\u0002\u00142\t!\"\u00198o_R\fG/[8o\u0013\u0011\t9*!$\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0002\u0005\u00028\u0005u$\u0019AA\u001d\u0011%\ti\nAI\u0001\n\u0003\ty*\u0001\ruef,\u0005p\u00197vg&4X\r\\=%I\u00164\u0017-\u001e7uIE*B!a!\u0002\"\u0012A\u0011qGAN\u0005\u0004\tI\u0004C\u0005\u0002&\u0002\t\n\u0011\"\u0001\u0002\u0004\u0006\tBO]=M_\u000e\\G\u0005Z3gCVdG\u000fJ\u0019")
public class FileLock
implements StrictLogging {
    public final Path ai$starlake$utils$FileLock$$path;
    public final StorageHandler ai$starlake$utils$FileLock$$storageHandler;
    private final LockWatcher fileWatcher;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public long checkinPeriod() {
        return this.ai$starlake$utils$FileLock$$storageHandler.lockAcquisitionPollTime().toMillis();
    }

    public long refreshPeriod() {
        return this.ai$starlake$utils$FileLock$$storageHandler.lockRefreshPollTime().toMillis();
    }

    private LockWatcher fileWatcher() {
        return this.fileWatcher;
    }

    public <T> Try<T> tryExclusively(long timeoutInMillis, Function0<T> op) {
        return Try$.MODULE$.apply((Function0)new Serializable(this, timeoutInMillis, op){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileLock $outer;
            private final long timeoutInMillis$1;
            private final Function0 op$1;

            public final T apply() {
                return this.$outer.doExclusively(this.timeoutInMillis$1, this.op$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timeoutInMillis$1 = timeoutInMillis$1;
                this.op$1 = op$1;
            }
        });
    }

    public <T> long tryExclusively$default$1() {
        return -1L;
    }

    public <T> T doExclusively(long timeoutInMillis, Function0<T> op) {
        if (this.tryLock(timeoutInMillis)) {
            return (T)op.apply();
        }
        throw new TimeoutException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to obtain lock on file ", " waited (millis) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ai$starlake$utils$FileLock$$path, BoxesRunTime.boxToLong((long)timeoutInMillis)})));
        finally {
            this.release();
        }
    }

    public <T> long doExclusively$default$1() {
        return -1L;
    }

    public boolean tryLock(long timeoutInMillis) {
        BoxedUnit boxedUnit;
        int maxTries;
        this.fileWatcher().checkPristine();
        this.ai$starlake$utils$FileLock$$storageHandler.mkdirs(this.ai$starlake$utils$FileLock$$path.getParent());
        int n = maxTries = timeoutInMillis == -1L ? Integer.MAX_VALUE : (int)(timeoutInMillis / this.checkinPeriod());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Trying to acquire lock for file {} during {} ms", new Object[]{this.ai$starlake$utils$FileLock$$path.toString(), BoxesRunTime.boxToLong((long)timeoutInMillis)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.getLock$1(maxTries);
    }

    public long tryLock$default$1() {
        return -1L;
    }

    public void release() {
        this.fileWatcher().release();
    }

    private void watch() {
        Thread th = new Thread((Runnable)this.fileWatcher(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LockWatcher-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)System.currentTimeMillis()), this.ai$starlake$utils$FileLock$$path.toString()})));
        th.start();
    }

    private final boolean getLock$1(int numberOfTries) {
        Try<BoxedUnit> try_;
        block14: {
            Try try_2;
            while (true) {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                block17: {
                    boolean bl;
                    block16: {
                        boolean bl2;
                        BoxedUnit boxedUnit3;
                        block15: {
                            if (numberOfTries != 0) break block15;
                            bl = false;
                            break block16;
                        }
                        try_ = this.ai$starlake$utils$FileLock$$storageHandler.touchz(this.ai$starlake$utils$FileLock$$path);
                        if (!(try_ instanceof Success)) break block17;
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("Succeeded to acquire lock for file {} after {} tries", new Object[]{this.ai$starlake$utils$FileLock$$path.toString(), BoxesRunTime.boxToInteger((int)numberOfTries)});
                            boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        this.watch();
                        bl = bl2 = true;
                    }
                    return bl;
                }
                if (!(try_ instanceof Failure)) break block14;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Audit lock {} already in use waiting ...  {}", new Object[]{this.ai$starlake$utils$FileLock$$path.toString(), e.getMessage()});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                try_2 = Try$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileLock $outer;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.$outer.ai$starlake$utils$FileLock$$storageHandler.lastModified(this.$outer.ai$starlake$utils$FileLock$$path);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                if (try_2 instanceof Success) {
                    BoxedUnit boxedUnit4;
                    Success success = (Success)try_2;
                    long lastModified = BoxesRunTime.unboxToLong((Object)success.value());
                    long currentTimeMillis = System.currentTimeMillis();
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                               |lastModified=", "\n                               |System.currentTimeMillis()=", "\n                               |checkinPeriod*4=", "\n                               |refreshPeriod*4=", "\n                               |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastModified), BoxesRunTime.boxToLong((long)currentTimeMillis), BoxesRunTime.boxToLong((long)(this.checkinPeriod() * 4L)), BoxesRunTime.boxToLong((long)(this.refreshPeriod() * 4L))})))).stripMargin());
                        boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                    boxedUnit = currentTimeMillis - lastModified > this.refreshPeriod() * 4L ? BoxesRunTime.boxToBoolean((boolean)this.ai$starlake$utils$FileLock$$storageHandler.delete(this.ai$starlake$utils$FileLock$$path)) : BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit5;
                    if (!(try_2 instanceof Failure)) break;
                    Failure failure2 = (Failure)try_2;
                    Throwable e2 = failure2.exception();
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("{} was deleted during access to modification date {}", new Object[]{this.ai$starlake$utils$FileLock$$path.toString(), e2.getMessage()});
                        boxedUnit5 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit5 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit5;
                }
                Thread.sleep(this.checkinPeriod());
                --numberOfTries;
            }
            throw new MatchError((Object)try_2);
        }
        throw new MatchError(try_);
    }

    public FileLock(Path path, StorageHandler storageHandler) {
        this.ai$starlake$utils$FileLock$$path = path;
        this.ai$starlake$utils$FileLock$$storageHandler = storageHandler;
        StrictLogging.class.$init$((StrictLogging)this);
        this.fileWatcher = new LockWatcher(path, storageHandler, this.refreshPeriod());
    }

    public static class LockWatcher
    implements Runnable,
    StrictLogging {
        private final Path path;
        private final StorageHandler storageHandler;
        private final long reportingPeriod;
        private final AtomicBoolean pristine;
        private final AtomicBoolean spent;
        private final Semaphore sem;
        private final Logger logger;

        public Logger logger() {
            return this.logger;
        }

        public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
            this.logger = x$1;
        }

        private AtomicBoolean pristine() {
            return this.pristine;
        }

        public void checkPristine() {
            boolean wasPristine = this.pristine().getAndSet(false);
            if (wasPristine) {
                return;
            }
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FileLock instance on ", " had already been used, cannot re-use"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path})));
        }

        private AtomicBoolean spent() {
            return this.spent;
        }

        private Semaphore sem() {
            return this.sem;
        }

        public void release() {
            boolean wasAlreadySpent = this.spent().getAndSet(true);
            if (wasAlreadySpent) {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LockWatcher thread on ", " already spent, cannot release again"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path})));
            }
            this.sem().release();
        }

        @Override
        public void run() {
            try {
                while (true) {
                    BoxedUnit boxedUnit;
                    if (this.sem().tryAcquire(this.reportingPeriod, TimeUnit.MILLISECONDS)) {
                        this.storageHandler.delete(this.path);
                        break;
                    }
                    this.storageHandler.touch(this.path);
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("watcher {} modified={}", new Object[]{this.path, BoxesRunTime.boxToLong((long)this.storageHandler.lastModified(this.path))});
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }

        public LockWatcher(Path path, StorageHandler storageHandler, long reportingPeriod) {
            this.path = path;
            this.storageHandler = storageHandler;
            this.reportingPeriod = reportingPeriod;
            StrictLogging.class.$init$((StrictLogging)this);
            this.pristine = new AtomicBoolean(true);
            this.spent = new AtomicBoolean(false);
            this.sem = new Semaphore(0);
        }
    }
}

