/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.utils;

import ai.starlake.config.Settings;
import ai.starlake.config.SparkEnv;
import ai.starlake.config.UdfRegistration;
import ai.starlake.schema.model.Metadata$;
import ai.starlake.schema.model.SinkType;
import ai.starlake.schema.model.SinkType$BQ$;
import ai.starlake.schema.model.SinkType$FS$;
import ai.starlake.schema.model.SinkType$JDBC$;
import ai.starlake.schema.model.SinkType$KAFKA$;
import ai.starlake.schema.model.Views;
import ai.starlake.utils.Formatter$;
import ai.starlake.utils.SparkJob;
import ai.starlake.utils.SparkJob$;
import ai.starlake.utils.Utils$;
import ai.starlake.utils.kafka.KafkaClient;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public abstract class SparkJob$class {
    public static SparkConf withExtraSparkConf(SparkJob $this, SparkConf sourceConfig) {
        BoxedUnit boxedUnit;
        sourceConfig.remove("spark.datasource.bigquery.allowFieldAddition");
        sourceConfig.remove("spark.datasource.bigquery.allowFieldRelaxation");
        String now = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss.SSS"));
        String appName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.name(), now}));
        SparkConf thisConf = sourceConfig.setAppName(appName).set("spark.app.id", appName);
        if ($this.logger().underlying().isDebugEnabled()) {
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug(thisConf.toDebugString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return thisConf;
    }

    public static SparkEnv ai$starlake$utils$SparkJob$$sparkEnv(SparkJob $this) {
        return new SparkEnv($this.name(), (Function1<SparkConf, SparkConf>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkJob $outer;

            public final SparkConf apply(SparkConf sourceConfig) {
                return this.$outer.withExtraSparkConf(sourceConfig);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, $this.settings());
    }

    public static void registerUdf(SparkJob $this, String udf) {
        UdfRegistration udfInstance = (UdfRegistration)Class.forName(udf).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        udfInstance.register($this.ai$starlake$utils$SparkJob$$sparkEnv().session());
    }

    public static SparkSession session(SparkJob $this) {
        List udfs = (List)$this.settings().comet().udfs().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(String udfs) {
                return Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(udfs)).split(',')).toList();
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        });
        udfs.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkJob $outer;

            public final void apply(String udf) {
                this.$outer.registerUdf(udf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return $this.ai$starlake$utils$SparkJob$$sparkEnv().session();
    }

    private static Dataset buildPartitionedDF(SparkJob $this, Dataset dataset, List cols) {
        ObjectRef partitionedDF = ObjectRef.create((Object)dataset.withColumn("comet_date", functions$.MODULE$.current_timestamp()));
        List dataSetsCols = Predef$.MODULE$.refArrayOps((Object[])dataset.columns()).toList();
        cols.foreach((Function1)new Serializable($this, partitionedDF, dataSetsCols){
            public static final long serialVersionUID = 0L;
            private final ObjectRef partitionedDF$1;
            private final List dataSetsCols$1;

            public final Object apply(String x0$1) {
                BoxedUnit boxedUnit;
                String string = x0$1;
                if ("comet_date".equals(string) && !this.dataSetsCols$1.contains((Object)"date")) {
                    this.partitionedDF$1.elem = ((Dataset)this.partitionedDF$1.elem).withColumn("date", functions$.MODULE$.date_format(functions$.MODULE$.col("comet_date"), "yyyyMMdd").cast((DataType)IntegerType$.MODULE$));
                    boxedUnit = BoxedUnit.UNIT;
                } else if ("comet_year".equals(string) && !this.dataSetsCols$1.contains((Object)"year")) {
                    this.partitionedDF$1.elem = ((Dataset)this.partitionedDF$1.elem).withColumn("year", functions$.MODULE$.year(functions$.MODULE$.col("comet_date")));
                    boxedUnit = BoxedUnit.UNIT;
                } else if ("comet_month".equals(string) && !this.dataSetsCols$1.contains((Object)"month")) {
                    this.partitionedDF$1.elem = ((Dataset)this.partitionedDF$1.elem).withColumn("month", functions$.MODULE$.month(functions$.MODULE$.col("comet_date")));
                    boxedUnit = BoxedUnit.UNIT;
                } else if ("comet_day".equals(string) && !this.dataSetsCols$1.contains((Object)"day")) {
                    this.partitionedDF$1.elem = ((Dataset)this.partitionedDF$1.elem).withColumn("day", functions$.MODULE$.dayofmonth(functions$.MODULE$.col("comet_date")));
                    boxedUnit = BoxedUnit.UNIT;
                } else if ("comet_hour".equals(string) && !this.dataSetsCols$1.contains((Object)"hour")) {
                    this.partitionedDF$1.elem = ((Dataset)this.partitionedDF$1.elem).withColumn("hour", functions$.MODULE$.hour(functions$.MODULE$.col("comet_date")));
                    boxedUnit = BoxedUnit.UNIT;
                } else if ("comet_minute".equals(string) && !this.dataSetsCols$1.contains((Object)"minute")) {
                    this.partitionedDF$1.elem = ((Dataset)this.partitionedDF$1.elem).withColumn("minute", functions$.MODULE$.minute(functions$.MODULE$.col("comet_date")));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = (Dataset)this.partitionedDF$1.elem;
                }
                return boxedUnit;
            }
            {
                this.partitionedDF$1 = partitionedDF$1;
                this.dataSetsCols$1 = dataSetsCols$1;
            }
        });
        return ((Dataset)partitionedDF.elem).drop("comet_date");
    }

    public static DataFrameWriter partitionedDatasetWriter(SparkJob $this, Dataset dataset, List partition) {
        DataFrameWriter dataFrameWriter;
        List list = partition;
        if (Nil$.MODULE$.equals(list)) {
            dataFrameWriter = dataset.write();
        } else if (list.forall((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object elem) {
                return Metadata$.MODULE$.CometPartitionColumns().contains(elem);
            }
        })) {
            List strippedCols = (List)list.map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$1) {
                    return x$1.substring("comet_".length());
                }
            }, List$.MODULE$.canBuildFrom());
            Dataset partitionedDF = SparkJob$class.buildPartitionedDF($this, dataset, list);
            dataFrameWriter = partitionedDF.write().partitionBy((Seq)strippedCols);
        } else {
            if (list.exists((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Object elem) {
                    return Metadata$.MODULE$.CometPartitionColumns().contains(elem);
                }
            })) {
                throw new Exception("Cannot mix comet & non comet col names");
            }
            dataFrameWriter = dataset.write().partitionBy((Seq)list);
        }
        return dataFrameWriter;
    }

    public static Dataset partitionDataset(SparkJob $this, Dataset dataset, List partition) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Partitioning on {}", new Object[]{partition.mkString(",")});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        List list = partition;
        Dataset dataset2 = Nil$.MODULE$.equals(list) ? dataset : (list.forall((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object elem) {
                return Metadata$.MODULE$.CometPartitionColumns().contains(elem);
            }
        }) ? SparkJob$class.buildPartitionedDF($this, dataset, list) : (list.exists((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object elem) {
                return Metadata$.MODULE$.CometPartitionColumns().contains(elem);
            }
        }) ? dataset : dataset));
        return dataset2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object analyze(SparkJob $this, String fullTableName) {
        BoxedUnit boxedUnit;
        if ($this.settings().comet().analyze()) {
            Some some;
            BoxedUnit boxedUnit2;
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info("computing statistics on table {}", new Object[]{fullTableName});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            String allCols = Predef$.MODULE$.refArrayOps((Object[])$this.session().table(fullTableName).columns()).mkString(",");
            $this.session().table(fullTableName);
            Try try_ = Try$.MODULE$.apply((Function0)new Serializable($this, fullTableName){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkJob $outer;
                private final String fullTableName$1;

                public final Some<String> apply() {
                    Dataset partitionedColsDF = this.$outer.session().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"show partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullTableName$1})));
                    String partitionedCols = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString((String)partitionedColsDF.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Row x$2) {
                            return (String)x$2.getAs(0);
                        }
                    }, this.$outer.session().implicits().newStringEncoder()).first())).split('/')).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String x$3) {
                            return x$3.split("=")[0];
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toList().mkString(",");
                    return new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ANALYZE TABLE ", " PARTITION (", ") COMPUTE STATISTICS"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullTableName$1, partitionedCols})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.fullTableName$1 = fullTableName$1;
                }
            });
            if (try_ instanceof Success) {
                Some value;
                Success success = (Success)try_;
                some = value = (Some)success.value();
            } else {
                BoxedUnit boxedUnit3;
                if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if ($this.logger().underlying().isInfoEnabled()) {
                    $this.logger().underlying().info(Utils$.MODULE$.exceptionAsString(e));
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                some = None$.MODULE$;
            }
            Some partitionedCols = some;
            StringOps stringOps = new StringOps(Predef$.MODULE$.augmentString($this.session().version().substring(0, 3)));
            if (stringOps.toDouble() >= 2.4) {
                List analyzeCommands = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ANALYZE TABLE ", " COMPUTE STATISTICS NOSCAN"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullTableName}))), partitionedCols, new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ANALYZE TABLE ", " COMPUTE STATISTICS FOR COLUMNS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullTableName, allCols})))})).flatten((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<String> apply(Option<String> xo) {
                        return Option$.MODULE$.option2Iterable(xo);
                    }
                });
                analyzeCommands.foreach((Function1)new Serializable($this, allCols, fullTableName){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SparkJob $outer;
                    private final String allCols$1;
                    private final String fullTableName$1;

                    public final Object apply(String command) {
                        Try try_;
                        block7: {
                            Dataset dataset;
                            block6: {
                                BoxedUnit boxedUnit;
                                block5: {
                                    Dataset df;
                                    try_ = Try$.MODULE$.apply((Function0)new Serializable(this, command){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ SparkJob$.anonfun.analyze.1 $outer;
                                        private final String command$1;

                                        public final Dataset<Row> apply() {
                                            return this.$outer.ai$starlake$utils$SparkJob$$anonfun$$$outer().session().sql(this.command$1);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.command$1 = command$1;
                                        }
                                    });
                                    if (!(try_ instanceof Success)) break block5;
                                    Success success = (Success)try_;
                                    dataset = df = (Dataset)success.value();
                                    break block6;
                                }
                                if (!(try_ instanceof Failure)) break block7;
                                Failure failure = (Failure)try_;
                                Throwable e = failure.exception();
                                if (this.$outer.logger().underlying().isWarnEnabled()) {
                                    this.$outer.logger().underlying().warn("Failed to compute statistics for table {} on columns {}", new Object[]{this.fullTableName$1, this.allCols$1});
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                e.printStackTrace();
                                dataset = BoxedUnit.UNIT;
                            }
                            return dataset;
                        }
                        throw new MatchError((Object)try_);
                    }

                    public /* synthetic */ SparkJob ai$starlake$utils$SparkJob$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.allCols$1 = allCols$1;
                        this.fullTableName$1 = fullTableName$1;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
                return boxedUnit;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static void createSparkViews(SparkJob $this, Views views, Map activeEnv, Map sqlParameters) {
        views.views().foreach((Function1)new Serializable($this, activeEnv, sqlParameters){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkJob $outer;
            private final Map activeEnv$1;
            private final Map sqlParameters$1;

            public final void apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    String valueWithEnv = Formatter$.MODULE$.RichFormatter(this.$outer.parseJinja(value, (Map<String, String>)this.activeEnv$1.$plus$plus((GenTraversableOnce)this.sqlParameters$1))).richFormat((Map<String, String>)this.activeEnv$1, (Map<String, String>)this.sqlParameters$1, this.$outer.settings());
                    Tuple3<SinkType, Option<String>, String> tuple3 = this.$outer.parseViewDefinition(valueWithEnv);
                    if (tuple3 != null) {
                        BoxedUnit boxedUnit;
                        BoxedUnit boxedUnit2;
                        Tuple3 tuple32;
                        SinkType sinkType = (SinkType)tuple3._1();
                        Option sinkConfig = (Option)tuple3._2();
                        String path = (String)tuple3._3();
                        Tuple3 tuple33 = tuple32 = new Tuple3((Object)sinkType, (Object)sinkConfig, (Object)path);
                        SinkType sinkType2 = (SinkType)tuple33._1();
                        Option sinkConfig2 = (Option)tuple33._2();
                        String path2 = (String)tuple33._3();
                        if (this.$outer.logger().underlying().isInfoEnabled()) {
                            this.$outer.logger().underlying().info("Loading view {} from {}", new Object[]{path2, sinkType2});
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        Dataset<Row> df = this.$outer.createSparkView(sinkType2, (Option<String>)sinkConfig2, path2);
                        df.createOrReplaceTempView(key);
                        if (this.$outer.logger().underlying().isInfoEnabled()) {
                            this.$outer.logger().underlying().info("Created view {}", new Object[]{key});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit;
                        return;
                    }
                    throw new MatchError(tuple3);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.activeEnv$1 = activeEnv$1;
                this.sqlParameters$1 = sqlParameters$1;
            }
        });
    }

    public static Dataset createSparkView(SparkJob $this, SinkType sinkType, Option sinkConfig, String path) {
        block6: {
            Dataset dataset;
            block3: {
                SinkType sinkType2;
                block5: {
                    block4: {
                        block2: {
                            sinkType2 = sinkType;
                            if (!((Object)SinkType$FS$.MODULE$).equals(sinkType2)) break block2;
                            dataset = SparkJob$class.createFSView($this, path);
                            break block3;
                        }
                        if (!((Object)SinkType$JDBC$.MODULE$).equals(sinkType2)) break block4;
                        dataset = SparkJob$class.createJDBCView($this, sinkConfig, path);
                        break block3;
                    }
                    if (!((Object)SinkType$KAFKA$.MODULE$).equals(sinkType2)) break block5;
                    dataset = SparkJob$class.createKafkaView($this, sinkConfig, path);
                    break block3;
                }
                if (!((Object)SinkType$BQ$.MODULE$).equals(sinkType2)) break block6;
                dataset = SparkJob$class.createBQView($this, path);
            }
            Dataset df = dataset;
            return df;
        }
        throw new Exception("Should never happen");
    }

    private static Dataset createJDBCView(SparkJob $this, Option sinkConfig, String path) {
        Settings.Connection jdbcConfig = (Settings.Connection)$this.settings().comet().connections().apply(sinkConfig.getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new Exception("");
            }
        }));
        return $this.session().read().options(jdbcConfig.options()).format(jdbcConfig.format()).option(JDBCOptions$.MODULE$.JDBC_QUERY_STRING(), path).load().cache();
    }

    private static Dataset createFSView(SparkJob $this, String path) {
        return path.startsWith("/") ? $this.session().read().format($this.settings().comet().defaultFormat()).load(path) : (path.trim().toLowerCase().startsWith("select ") ? $this.session().sql(path) : $this.session().read().format($this.settings().comet().defaultFormat()).load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.settings().comet().datasets(), path}))));
    }

    private static Dataset createBQView(SparkJob $this, String path) {
        Dataset dataset;
        String string;
        Regex TablePathWithFilter = new StringOps(Predef$.MODULE$.augmentString("(.*)\\.comet_filter\\((.*)\\)")).r();
        Regex TablePathWithSelect = new StringOps(Predef$.MODULE$.augmentString("(.*)\\.comet_select\\((.*)\\)")).r();
        Regex TablePathWithFilterAndSelect = new StringOps(Predef$.MODULE$.augmentString("(.*)\\.comet_select\\((.*)\\)\\.comet_filter\\((.*)\\)")).r();
        Option option2 = TablePathWithFilterAndSelect.unapplySeq((CharSequence)(string = path));
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(3) == 0) {
            BoxedUnit boxedUnit;
            String tablePath = (String)((LinearSeqOptimized)option2.get()).apply(0);
            String select = (String)((LinearSeqOptimized)option2.get()).apply(1);
            String filter = (String)((LinearSeqOptimized)option2.get()).apply(2);
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info("We are loading the Table with columns: {} and filters: {}", new Object[]{select, filter});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            dataset = $this.session().read().option("readDataFormat", "AVRO").format("com.google.cloud.spark.bigquery").option("table", tablePath).option("filter", filter).load().selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])select.replaceAll("\\s", "").split(","))).cache();
        } else {
            Option option3 = TablePathWithFilter.unapplySeq((CharSequence)string);
            if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
                BoxedUnit boxedUnit;
                String tablePath = (String)((LinearSeqOptimized)option3.get()).apply(0);
                String filter = (String)((LinearSeqOptimized)option3.get()).apply(1);
                if ($this.logger().underlying().isInfoEnabled()) {
                    $this.logger().underlying().info("We are loading the Table with filters: {}", new Object[]{filter});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                dataset = $this.session().read().option("readDataFormat", "AVRO").format("com.google.cloud.spark.bigquery").option("table", tablePath).option("filter", filter).load().cache();
            } else {
                Option option4 = TablePathWithSelect.unapplySeq((CharSequence)string);
                if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(2) == 0) {
                    BoxedUnit boxedUnit;
                    String tablePath = (String)((LinearSeqOptimized)option4.get()).apply(0);
                    String select = (String)((LinearSeqOptimized)option4.get()).apply(1);
                    if ($this.logger().underlying().isInfoEnabled()) {
                        $this.logger().underlying().info("We are loading the Table with columns: {}", new Object[]{select});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    dataset = $this.session().read().option("readDataFormat", "AVRO").format("com.google.cloud.spark.bigquery").option("table", tablePath).load().selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])select.replaceAll("\\s", "").split(","))).cache();
                } else {
                    dataset = $this.session().read().option("readDataFormat", "AVRO").format("com.google.cloud.spark.bigquery").option("table", path).load().cache();
                }
            }
        }
        return dataset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Dataset createKafkaView(SparkJob $this, Option sinkConfig, String path) {
        Option option2 = sinkConfig;
        if (!(option2 instanceof Some)) return (Dataset)Utils$.MODULE$.withResources(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkJob $outer;

            public final KafkaClient apply() {
                return new KafkaClient(this.$outer.settings().comet().kafka(), this.$outer.settings());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Serializable($this, path){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkJob $outer;
            private final String path$1;

            /*
             * WARNING - void declaration
             */
            public final Dataset<Row> apply(KafkaClient kafkaClient) {
                Tuple2<Dataset<Row>, List<Tuple2<Object, Object>>> tuple2 = kafkaClient.consumeTopicBatch(this.path$1, this.$outer.session(), (Settings.KafkaTopicConfig)this.$outer.settings().comet().kafka().topics().apply((Object)this.path$1));
                if (tuple2 != null) {
                    void var2_5;
                    Dataset dataframe;
                    Dataset dataset;
                    Dataset dataframe2 = dataset = (dataframe = (Dataset)tuple2._1());
                    return var2_5;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.path$1 = path$1;
            }
        });
        Some some = (Some)option2;
        String x = (String)some.x();
        String string = x.toLowerCase();
        String string2 = "stream";
        if (string != null) {
            if (!string.equals(string2)) return (Dataset)Utils$.MODULE$.withResources(new /* invalid duplicate definition of identical inner class */, new /* invalid duplicate definition of identical inner class */);
            return (Dataset)Utils$.MODULE$.withResources(new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkJob $outer;

                public final KafkaClient apply() {
                    return new KafkaClient(this.$outer.settings().comet().kafka(), this.$outer.settings());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, new Serializable($this, path){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkJob $outer;
                private final String path$1;

                public final Dataset<Row> apply(KafkaClient kafkaClient) {
                    return kafkaClient.consumeTopicStreaming(this.$outer.session(), (Settings.KafkaTopicConfig)this.$outer.settings().comet().kafka().topics().apply((Object)this.path$1));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.path$1 = path$1;
                }
            });
        }
        if (string2 == null) return (Dataset)Utils$.MODULE$.withResources(new /* invalid duplicate definition of identical inner class */, new /* invalid duplicate definition of identical inner class */);
        return (Dataset)Utils$.MODULE$.withResources(new /* invalid duplicate definition of identical inner class */, new /* invalid duplicate definition of identical inner class */);
    }

    public static void $init$(SparkJob $this) {
    }
}

