/*
 * Decompiled with CFR 0.152.
 */
package ai.starlake.utils.conversion;

import ai.starlake.utils.repackaged.BigQuerySchemaConverters;
import com.google.cloud.bigquery.Schema;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;

public final class BigQueryUtils$ {
    public static final BigQueryUtils$ MODULE$;
    private final Function1<Dataset<Row>, Schema> sparkToBq;

    static {
        new BigQueryUtils$();
    }

    public Function1<Dataset<Row>, Schema> sparkToBq() {
        return this.sparkToBq;
    }

    public Schema bqSchema(DataType schema) {
        return BigQuerySchemaConverters.toBigQuerySchema((StructType)schema);
    }

    public StructType normalizeSchema(StructType schema) {
        StructField[] fields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final StructField apply(StructField field) {
                boolean bl = false;
                ArrayType arrayType = null;
                DataType dataType = field.dataType();
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    StructType x$2 = BigQueryUtils$.MODULE$.normalizeSchema(structType);
                    String x$3 = field.copy$default$1();
                    boolean x$4 = field.copy$default$3();
                    Metadata x$5 = field.copy$default$4();
                    return field.copy(x$3, (DataType)x$2, x$4, x$5);
                }
                if (dataType instanceof ArrayType) {
                    bl = true;
                    arrayType = (ArrayType)dataType;
                    DataType elementType = arrayType.elementType();
                    boolean nullable = arrayType.containsNull();
                    if (elementType instanceof StructType) {
                        StructType structType = (StructType)elementType;
                        ArrayType x$6 = new ArrayType((DataType)BigQueryUtils$.MODULE$.normalizeSchema(structType), nullable);
                        String x$7 = field.copy$default$1();
                        boolean x$8 = field.copy$default$3();
                        Metadata x$9 = field.copy$default$4();
                        return field.copy(x$7, (DataType)x$6, x$8, x$9);
                    }
                }
                if (bl) {
                    boolean nullable = arrayType.containsNull();
                    if (arrayType.elementType() instanceof IntegerType) {
                        ArrayType x$10 = new ArrayType((DataType)LongType$.MODULE$, nullable);
                        String x$11 = field.copy$default$1();
                        boolean x$12 = field.copy$default$3();
                        Metadata x$13 = field.copy$default$4();
                        return field.copy(x$11, (DataType)x$10, x$12, x$13);
                    }
                }
                if (!IntegerType$.MODULE$.equals(dataType)) return field;
                LongType$ x$14 = LongType$.MODULE$;
                String x$15 = field.copy$default$1();
                boolean x$16 = field.copy$default$3();
                Metadata x$17 = field.copy$default$4();
                return field.copy(x$15, (DataType)x$14, x$16, x$17);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        return schema.copy(fields);
    }

    public List<String> computePartitionsToUpdateAfterMerge(Dataset<Row> mergedDF, Dataset<Row> toDeleteDF, String timestamp) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])mergedDF.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(timestamp)})).union(toDeleteDF.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(timestamp)}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.date_format(functions$.MODULE$.col(timestamp), "yyyyMMdd").cast("string")})).where(functions$.MODULE$.col(timestamp).isNotNull()).distinct().collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row x$1) {
                return x$1.getString(0);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toList();
    }

    private BigQueryUtils$() {
        MODULE$ = this;
        this.sparkToBq = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Schema apply(Dataset<Row> df) {
                return BigQueryUtils$.MODULE$.bqSchema((DataType)df.schema());
            }
        };
    }
}

