/*
 * Decompiled with CFR 0.152.
 */
package ai.superstream;

import ai.superstream.Consts;
import ai.superstream.Superstream;
import com.google.protobuf.Descriptors;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class SuperstreamDeserializer<T>
implements Deserializer<T> {
    private Deserializer<T> originalDeserializer;
    private Superstream superstreamConnection;

    public void configure(Map<String, ?> configs, boolean isKey) {
        try {
            Superstream superstreamConn;
            Deserializer originalDeserializerT;
            String originalDeserializerClassName;
            String superstreamHost;
            String token;
            String string = token = configs.get("superstream.token") != null ? (String)configs.get("superstream.token") : null;
            if (token == null) {
                throw new Exception("token is required");
            }
            String string2 = superstreamHost = configs.get("superstream.host") != null ? (String)configs.get("superstream.host") : "broker.superstream.dev";
            if (superstreamHost == null) {
                superstreamHost = "broker.superstream.dev";
            }
            int learningFactor = configs.get("superstream.learning.factor") != null ? (Integer)configs.get("superstream.learning.factor") : Consts.superstreamDefaultLearningFactor;
            String string3 = originalDeserializerClassName = configs.get("original.deserializer") != null ? (String)configs.get("original.deserializer") : null;
            if (originalDeserializerClassName == null) {
                throw new Exception("original deserializer is required");
            }
            Class<?> originalDeserializerClass = Class.forName(originalDeserializerClassName);
            this.originalDeserializer = originalDeserializerT = (Deserializer)originalDeserializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.originalDeserializer.configure(configs, isKey);
            this.superstreamConnection = superstreamConn = new Superstream(token, superstreamHost, learningFactor, "consumer", configs);
            this.superstreamConnection.config = configs;
        }
        catch (Exception e) {
            String errMsg = String.format("superstream: error initializing superstream: %s", e.getMessage());
            if (this.superstreamConnection != null) {
                this.superstreamConnection.handleError(errMsg);
            }
            System.out.println(errMsg);
        }
    }

    public T deserialize(String topic, byte[] data) {
        Object deserializedData = this.originalDeserializer.deserialize(topic, data);
        return (T)deserializedData;
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        Header header;
        String schemaId = null;
        byte[] dataToDesrialize = data;
        if (this.superstreamConnection != null) {
            this.superstreamConnection.clientCounters.incrementTotalBytesAfterReduction(data.length);
        }
        if ((header = headers.lastHeader("superstream_schema")) != null) {
            schemaId = new String(header.value(), StandardCharsets.UTF_8);
        }
        if (schemaId != null) {
            Descriptors.Descriptor desc = this.superstreamConnection.SchemaIDMap.get(schemaId);
            if (desc == null) {
                this.superstreamConnection.sendGetSchemaRequest(schemaId);
                desc = this.superstreamConnection.SchemaIDMap.get(schemaId);
                if (desc == null) {
                    this.superstreamConnection.handleError("error getting schema with id: " + schemaId);
                    System.out.println("superstream: shcema not found");
                    return null;
                }
            }
            try {
                byte[] supertstreamDeserialized = this.superstreamConnection.protoToJson(data, desc);
                dataToDesrialize = supertstreamDeserialized;
                this.superstreamConnection.clientCounters.incrementTotalBytesBeforeReduction(supertstreamDeserialized.length);
                this.superstreamConnection.clientCounters.incrementTotalMessagesSuccessfullyConsumed();
            }
            catch (Exception e) {
                this.superstreamConnection.handleError(String.format("error deserializing data: %s", e.getMessage()));
                return null;
            }
        } else {
            this.superstreamConnection.clientCounters.incrementTotalBytesBeforeReduction(data.length);
            this.superstreamConnection.clientCounters.incrementTotalMessagesFailedConsume();
        }
        Object deserializedData = this.originalDeserializer.deserialize(topic, dataToDesrialize);
        return (T)deserializedData;
    }

    public void close() {
        this.originalDeserializer.close();
        this.superstreamConnection.close();
    }
}

