/*
 * Decompiled with CFR 0.152.
 */
package ai.superstream;

import ai.superstream.Consts;
import ai.superstream.Superstream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.serialization.Serializer;

public class SuperstreamSerializer<T>
implements Serializer<T> {
    private Serializer<T> originalSerializer;
    private Superstream superstreamConnection;

    public void configure(Map<String, ?> configs, boolean isKey) {
        try {
            Superstream superstreamConn;
            Serializer originalSerializerT;
            String originalSerializerClassName;
            String superstreamHost;
            String token;
            String string = token = configs.get("superstream.token") != null ? (String)configs.get("superstream.token") : null;
            if (token == null) {
                throw new Exception("token is required");
            }
            String string2 = superstreamHost = configs.get("superstream.host") != null ? (String)configs.get("superstream.host") : "broker.superstream.dev";
            if (superstreamHost == null) {
                superstreamHost = "broker.superstream.dev";
            }
            int learningFactor = configs.get("superstream.learning.factor") != null ? (Integer)configs.get("superstream.learning.factor") : Consts.superstreamDefaultLearningFactor;
            String string3 = originalSerializerClassName = configs.get("original.serializer") != null ? (String)configs.get("original.serializer") : null;
            if (originalSerializerClassName == null) {
                throw new Exception("original serializer is required");
            }
            Class<?> originalSerializerClass = Class.forName(originalSerializerClassName);
            this.originalSerializer = originalSerializerT = (Serializer)originalSerializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.originalSerializer.configure(configs, isKey);
            this.superstreamConnection = superstreamConn = new Superstream(token, superstreamHost, learningFactor, "producer", configs);
            this.superstreamConnection.config = configs;
        }
        catch (Exception e) {
            String errMsg = String.format("superstream: error initializing superstream: %s", e.getMessage());
            if (this.superstreamConnection != null) {
                this.superstreamConnection.handleError(errMsg);
            }
            System.out.println(errMsg);
        }
    }

    public byte[] serialize(String topic, T data) {
        byte[] serializedData = this.originalSerializer.serialize(topic, data);
        return serializedData;
    }

    public byte[] serialize(String topic, Headers headers, T data) {
        byte[] serializedResult;
        byte[] serializedData = this.originalSerializer.serialize(topic, data);
        if (this.superstreamConnection != null) {
            if (this.superstreamConnection.descriptor != null) {
                try {
                    RecordHeader header = new RecordHeader("superstream_schema", this.superstreamConnection.ProducerSchemaID.getBytes(StandardCharsets.UTF_8));
                    headers.add((Header)header);
                    byte[] superstreamSerialized = this.superstreamConnection.jsonToProto(serializedData);
                    this.superstreamConnection.clientCounters.incrementTotalBytesBeforeReduction(serializedData.length);
                    this.superstreamConnection.clientCounters.incrementTotalBytesAfterReduction(superstreamSerialized.length);
                    this.superstreamConnection.clientCounters.incrementTotalMessagesSuccessfullyProduce();
                    return superstreamSerialized;
                }
                catch (Exception e) {
                    serializedResult = serializedData;
                    this.superstreamConnection.handleError(String.format("error serializing data: ", e.getMessage()));
                    this.superstreamConnection.clientCounters.incrementTotalBytesAfterReduction(serializedData.length);
                    this.superstreamConnection.clientCounters.incrementTotalMessagesFailedProduce();
                }
            } else {
                serializedResult = serializedData;
                this.superstreamConnection.clientCounters.incrementTotalBytesAfterReduction(serializedData.length);
                if (this.superstreamConnection.learningFactorCounter <= this.superstreamConnection.learningFactor) {
                    this.superstreamConnection.sendLearningMessage(serializedResult);
                    ++this.superstreamConnection.learningFactorCounter;
                } else if (!this.superstreamConnection.learningRequestSent) {
                    this.superstreamConnection.sendRegisterSchemaReq();
                }
            }
        } else {
            serializedResult = serializedData;
        }
        return serializedResult;
    }

    public void close() {
        this.originalSerializer.close();
        if (this.superstreamConnection != null) {
            this.superstreamConnection.close();
        }
    }
}

