/*
 * Decompiled with CFR 0.152.
 */
package ai.superstream;

import ai.superstream.Consts;
import ai.superstream.SuperstreamConsumerInterceptor;
import ai.superstream.SuperstreamCounters;
import ai.superstream.SuperstreamDeserializer;
import ai.superstream.SuperstreamProducerInterceptor;
import ai.superstream.SuperstreamSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.nats.client.Connection;
import io.nats.client.ConnectionListener;
import io.nats.client.Dispatcher;
import io.nats.client.JetStream;
import io.nats.client.Message;
import io.nats.client.MessageHandler;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.Subscription;
import io.nats.client.api.ServerInfo;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.StringDeserializer;

public class Superstream {
    public Connection brokerConnection;
    public JetStream jetstream;
    public String superstreamJwt;
    public String superstreamNkey;
    public byte[] descriptorAsBytes;
    public Descriptors.Descriptor descriptor;
    public String natsConnectionID;
    public int clientID;
    public String accountName;
    public int learningFactor = 20;
    public int learningFactorCounter = 0;
    public boolean learningRequestSent = false;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    public String ProducerSchemaID = "0";
    public String ConsumerSchemaID = "0";
    public Map<String, Descriptors.Descriptor> SchemaIDMap = new HashMap<String, Descriptors.Descriptor>();
    public Map<String, Object> configs;
    public SuperstreamCounters clientCounters = new SuperstreamCounters();
    private Subscription updatesSubscription;
    private String host;
    private String token;
    public String type;
    public Boolean reductionEnabled;
    public Map<String, Set<Integer>> topicPartitions = new ConcurrentHashMap<String, Set<Integer>>();
    public ExecutorService executorService = Executors.newCachedThreadPool();
    private Integer kafkaConnectionID = 0;

    public Superstream(String token, String host, Integer learningFactor, Map<String, Object> configs, Boolean enableReduction, String type) {
        this.learningFactor = learningFactor;
        this.token = token;
        this.host = host;
        this.configs = configs;
        this.reductionEnabled = enableReduction;
        this.type = type;
    }

    public void init() {
        try {
            this.initializeNatsConnection(this.token, this.host);
            if (this.brokerConnection != null) {
                this.registerClient(this.configs);
                this.subscribeToUpdates();
                this.reportClientsUpdate();
                this.sendClientTypeUpdateReq();
            }
        }
        catch (Exception e) {
            this.handleError(e.getMessage());
        }
    }

    public void close() {
        try {
            if (this.brokerConnection != null) {
                this.brokerConnection.close();
            }
            this.executorService.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initializeNatsConnection(String token, String host) {
        try {
            Options options = new Options.Builder().server(host).userInfo("superstream_internal", token).maxReconnects(-1).reconnectWait(Duration.ofSeconds(1L)).connectionListener(new ConnectionListener(){

                public void connectionEvent(Connection conn, ConnectionListener.Events type) {
                    if (type == ConnectionListener.Events.DISCONNECTED) {
                        System.out.println("superstream: Disconnected");
                    } else if (type == ConnectionListener.Events.RECONNECTED) {
                        try {
                            if (Superstream.this.brokerConnection != null) {
                                Superstream.this.natsConnectionID = Superstream.this.generateNatsConnectionID();
                                HashMap<String, Object> reqData = new HashMap<String, Object>();
                                reqData.put("new_nats_connection_id", Superstream.this.natsConnectionID);
                                reqData.put("client_id", Superstream.this.clientID);
                                ObjectMapper mapper = new ObjectMapper();
                                byte[] reqBytes = mapper.writeValueAsBytes(reqData);
                                Superstream.this.brokerConnection.request("internal.clientReconnectionUpdate", reqBytes, Duration.ofSeconds(30L));
                            }
                        }
                        catch (Exception e) {
                            System.out.println("superstream: Failed to send reconnection update: " + e.getMessage());
                        }
                        System.out.println("superstream: Reconnected to superstream");
                    }
                }
            }).build();
            Connection nc = Nats.connect((Options)options);
            if (nc == null) {
                throw new Exception(String.format("Failed to connect to host: %s", host));
            }
            JetStream js = nc.jetStream();
            if (js == null) {
                throw new Exception(String.format("Failed to connect to host: %s", host));
            }
            this.brokerConnection = nc;
            this.jetstream = js;
            this.natsConnectionID = this.generateNatsConnectionID();
        }
        catch (Exception e) {
            System.out.println(String.format("superstream: %s", e.getMessage()));
        }
    }

    private String generateNatsConnectionID() {
        ServerInfo serverInfo = this.brokerConnection.getServerInfo();
        String connectedServerName = serverInfo.getServerName();
        int serverClientID = serverInfo.getClientId();
        return connectedServerName + ":" + serverClientID;
    }

    public void registerClient(Map<String, ?> configs) {
        try {
            String kafkaConnID = this.consumeConnectionID();
            if (kafkaConnID != null) {
                try {
                    this.kafkaConnectionID = Integer.parseInt(kafkaConnID);
                }
                catch (Exception e) {
                    this.kafkaConnectionID = 0;
                }
            }
            this.kafkaConnectionID = 0;
            HashMap<String, Object> reqData = new HashMap<String, Object>();
            reqData.put("nats_connection_id", this.natsConnectionID);
            reqData.put("language", "java");
            reqData.put("learning_factor", this.learningFactor);
            reqData.put("version", "1.0.5");
            reqData.put("config", Superstream.normalizeClientConfig(configs));
            reqData.put("reduction_enabled", this.reductionEnabled);
            reqData.put("connection_id", this.kafkaConnectionID);
            ObjectMapper mapper = new ObjectMapper();
            byte[] reqBytes = mapper.writeValueAsBytes(reqData);
            Message reply = this.brokerConnection.request("internal.registerClient", reqBytes, Duration.ofSeconds(30L));
            if (reply != null) {
                Map replyData = (Map)mapper.readValue(reply.getData(), Map.class);
                Object clientIDObject = replyData.get("client_id");
                if (clientIDObject instanceof Integer) {
                    this.clientID = (Integer)clientIDObject;
                } else if (clientIDObject instanceof String) {
                    try {
                        this.clientID = Integer.parseInt((String)clientIDObject);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("superstream: client_id is not a valid integer: " + clientIDObject);
                    }
                } else {
                    System.err.println("superstream: client_id is not a valid integer: " + clientIDObject);
                }
                Object accountNameObject = replyData.get("account_name");
                if (accountNameObject != null) {
                    this.accountName = accountNameObject.toString();
                } else {
                    System.err.println("superstream: account_name is not a valid string: " + accountNameObject);
                }
                Object learningFactorObject = replyData.get("learning_factor");
                if (learningFactorObject instanceof Integer) {
                    this.learningFactor = (Integer)learningFactorObject;
                } else if (learningFactorObject instanceof String) {
                    try {
                        this.learningFactor = Integer.parseInt((String)learningFactorObject);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("superstream: learning_factor is not a valid integer: " + learningFactorObject);
                    }
                } else {
                    System.err.println("superstream: learning_factor is not a valid integer: " + learningFactorObject);
                }
            } else {
                String errMsg = "superstream: registering client: No reply received within the timeout period.";
                System.out.println(errMsg);
                this.handleError(errMsg);
            }
        }
        catch (Exception e) {
            System.out.println(String.format("superstream: %s", e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String consumeConnectionID() {
        Properties consumerProps = this.copyAuthConfig();
        consumerProps.put("key.deserializer", StringDeserializer.class.getName());
        consumerProps.put("value.deserializer", StringDeserializer.class.getName());
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("superstream.inner.consumer", "true");
        String connectionId = null;
        try (KafkaConsumer consumer = new KafkaConsumer(consumerProps);){
            TopicPartition topicPartition = new TopicPartition("superstream.metadata", 0);
            consumer.assign(Collections.singletonList(topicPartition));
            ConsumerRecords records = consumer.poll(Duration.ofSeconds(10L));
            Iterator iterator = records.iterator();
            if (iterator.hasNext()) {
                ConsumerRecord record = (ConsumerRecord)iterator.next();
                connectionId = (String)record.value();
            }
        }
        return connectionId;
    }

    private Properties copyAuthConfig() {
        String[] relevantKeys = new String[]{"security.protocol", "ssl.truststore.location", "ssl.truststore.password", "ssl.keystore.location", "ssl.keystore.password", "ssl.key.password", "ssl.endpoint.identification.algorithm", "sasl.mechanism", "sasl.jaas.config", "sasl.kerberos.service.name", "bootstrap.servers", "client.dns.lookup", "connections.max.idle.ms", "request.timeout.ms", "metadata.max.age.ms", "reconnect.backoff.ms", "reconnect.backoff.max.ms"};
        Properties relevantProps = new Properties();
        for (String key : relevantKeys) {
            if (!this.configs.containsKey(key)) continue;
            relevantProps.put(key, String.valueOf(this.configs.get(key)));
        }
        return relevantProps;
    }

    public void sendClientTypeUpdateReq() {
        if (this.type == "" || this.type == null) {
            return;
        }
        if (this.type != "consumer" && this.type != "producer") {
            return;
        }
        try {
            HashMap<String, Object> reqData = new HashMap<String, Object>();
            reqData.put("client_id", this.clientID);
            reqData.put("type", this.type);
            ObjectMapper mapper = new ObjectMapper();
            byte[] reqBytes = mapper.writeValueAsBytes(reqData);
            this.brokerConnection.request("internal.clientTypeUpdate", reqBytes, Duration.ofSeconds(30L));
        }
        catch (Exception e) {
            this.handleError(String.format("sendClientTypeUpdateReq: %s", e.getMessage()));
        }
    }

    public void subscribeToUpdates() {
        try {
            String subject = String.format("internal.updates.%d", this.clientID);
            Dispatcher dispatcher = this.brokerConnection.createDispatcher(this.updatesHandler());
            this.updatesSubscription = dispatcher.subscribe(subject, this.updatesHandler());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reportClientsUpdate() {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        executorService.scheduleAtFixedRate(() -> {
            try {
                byte[] byteCounters = objectMapper.writeValueAsBytes((Object)this.clientCounters);
                HashMap<String, Map<String, Object>> topicPartitionConfig = new HashMap<String, Map<String, Object>>();
                if (!this.topicPartitions.isEmpty()) {
                    Map<String, Integer[]> topicPartitionsToSend = Superstream.convertMap(this.topicPartitions);
                    switch (this.type) {
                        case "producer": {
                            topicPartitionConfig.put("producer_topics_partitions", topicPartitionsToSend);
                            topicPartitionConfig.put("consumer_group_topics_partitions", new HashMap());
                            break;
                        }
                        case "consumer": {
                            topicPartitionConfig.put("producer_topics_partitions", new HashMap());
                            topicPartitionConfig.put("consumer_group_topics_partitions", topicPartitionsToSend);
                        }
                    }
                }
                byte[] byteConfig = objectMapper.writeValueAsBytes(topicPartitionConfig);
                this.brokerConnection.publish(String.format("internal_tasks.clientsUpdate.%s.%d", "counters", this.clientID), byteCounters);
                this.brokerConnection.publish(String.format("internal_tasks.clientsUpdate.%s.%d", "config", this.clientID), byteConfig);
            }
            catch (Exception e) {
                this.handleError("reportClientsUpdate: " + e.getMessage());
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    public static Map<String, Integer[]> convertMap(Map<String, Set<Integer>> topicPartitions) {
        HashMap<String, Integer[]> result = new HashMap<String, Integer[]>();
        for (Map.Entry<String, Set<Integer>> entry : topicPartitions.entrySet()) {
            Integer[] array = entry.getValue().toArray(new Integer[0]);
            result.put(entry.getKey(), array);
        }
        return result;
    }

    public void sendLearningMessage(byte[] msg) {
        try {
            this.brokerConnection.publish(String.format("internal.schema.learnSchema.%d", this.clientID), msg);
        }
        catch (Exception e) {
            this.handleError("sendLearningMessage: " + e.getMessage());
        }
    }

    public void sendRegisterSchemaReq() {
        try {
            this.brokerConnection.publish(String.format("internal_tasks.schema.registerSchema.%d", this.clientID), new byte[0]);
            this.learningRequestSent = true;
        }
        catch (Exception e) {
            this.handleError("sendLearningMessage: " + e.getMessage());
        }
    }

    public byte[] jsonToProto(byte[] msgBytes) throws IOException {
        try {
            String jsonString = new String(msgBytes);
            DynamicMessage.Builder newMessageBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)this.descriptor);
            JsonFormat.parser().merge(jsonString, (Message.Builder)newMessageBuilder);
            DynamicMessage message = newMessageBuilder.build();
            return message.toByteArray();
        }
        catch (Exception e) {
            if (e.getMessage().contains("Cannot find field")) {
                return msgBytes;
            }
            return msgBytes;
        }
    }

    public byte[] protoToJson(byte[] msgBytes, Descriptors.Descriptor desc) throws IOException {
        try {
            DynamicMessage message = DynamicMessage.parseFrom((Descriptors.Descriptor)desc, (byte[])msgBytes);
            String jsonString = JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)message);
            return jsonString.getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            if (e.getMessage().contains("the input ended unexpectedly")) {
                return msgBytes;
            }
            return msgBytes;
        }
    }

    private MessageHandler updatesHandler() {
        return msg -> {
            try {
                Map update = (Map)objectMapper.readValue(msg.getData(), Map.class);
                this.processUpdate(update);
            }
            catch (IOException e) {
                this.handleError("updatesHandler at json.Unmarshal: " + e.getMessage());
            }
        };
    }

    private void processUpdate(Map<String, Object> update) {
        String type = (String)update.get("type");
        try {
            String payloadBytesString = (String)update.get("payload");
            byte[] payloadBytes = Base64.getDecoder().decode(payloadBytesString);
            Map payload = (Map)objectMapper.readValue(payloadBytes, Map.class);
            switch (type) {
                case "LearnedSchema": {
                    String schemaID;
                    String descriptorBytesString = (String)payload.get("desc");
                    String masterMsgName = (String)payload.get("master_msg_name");
                    String fileName = (String)payload.get("file_name");
                    this.descriptor = this.compileMsgDescriptor(descriptorBytesString, masterMsgName, fileName);
                    this.ProducerSchemaID = schemaID = (String)payload.get("schema_id");
                    break;
                }
                case "ToggleReduction": {
                    Boolean enableReduction = (Boolean)payload.get("enable_reduction");
                    this.reductionEnabled = enableReduction != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
                }
            }
        }
        catch (Exception e) {
            this.handleError("processUpdate: " + e.getMessage());
        }
    }

    public void sendGetSchemaRequest(String schemaID) {
        try {
            Descriptors.Descriptor respDescriptor;
            HashMap<String, String> reqData = new HashMap<String, String>();
            reqData.put("schema_id", schemaID);
            ObjectMapper mapper = new ObjectMapper();
            byte[] reqBytes = mapper.writeValueAsBytes(reqData);
            Message msg = this.brokerConnection.request(String.format("internal.schema.getSchema.%d", this.clientID), reqBytes, Duration.ofSeconds(30L));
            if (msg == null) {
                throw new Exception("Could not get descriptor");
            }
            Map respMap = (Map)objectMapper.readValue(new String(msg.getData(), StandardCharsets.UTF_8), Map.class);
            if (respMap.containsKey("desc") && respMap.get("desc") instanceof String) {
                String fileName;
                String masterMsgName;
                String descriptorBytesString = (String)respMap.get("desc");
                respDescriptor = this.compileMsgDescriptor(descriptorBytesString, masterMsgName = (String)respMap.get("master_msg_name"), fileName = (String)respMap.get("file_name"));
                if (respDescriptor == null) {
                    throw new Exception("Error compiling schema.");
                }
            } else {
                throw new Exception("Response map does not contain expected keys.");
            }
            this.SchemaIDMap.put((String)respMap.get("schema_id"), respDescriptor);
        }
        catch (Exception e) {
            this.handleError(String.format("sendGetSchemaRequest: %s", e.getMessage()));
        }
    }

    private Descriptors.Descriptor compileMsgDescriptor(String descriptorBytesString, String masterMsgName, String fileName) {
        try {
            byte[] descriptorAsBytes = Base64.getDecoder().decode(descriptorBytesString);
            if (descriptorAsBytes == null) {
                throw new Exception("error decoding descriptor bytes");
            }
            DescriptorProtos.FileDescriptorSet descriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom((byte[])descriptorAsBytes);
            Descriptors.FileDescriptor fileDescriptor = null;
            for (DescriptorProtos.FileDescriptorProto fdp : descriptorSet.getFileList()) {
                if (!fdp.getName().equals(fileName)) continue;
                fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fdp, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
                break;
            }
            if (fileDescriptor == null) {
                throw new Exception("file not found");
            }
            for (Descriptors.Descriptor md : fileDescriptor.getMessageTypes()) {
                if (!md.getName().equals(masterMsgName)) continue;
                return md;
            }
        }
        catch (Exception e) {
            this.handleError(String.format("compileMsgDescriptor: %s", e.getMessage()));
        }
        return null;
    }

    public void handleError(String msg) {
        if (this.brokerConnection != null) {
            if (this.clientID == 0) {
                String message = String.format("[sdk: java][version: %s][connectionID: %s] %s", "1.0.5", msg);
                this.brokerConnection.publish("internal.clientErrors", message.getBytes(StandardCharsets.UTF_8));
            } else {
                String message = String.format("[account name: %s][clientID: %d][sdk: java][version: %s] %s", this.accountName, this.clientID, "1.0.5", msg);
                this.brokerConnection.publish("internal.clientErrors", message.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    public static Map<String, Object> normalizeClientConfig(Map<String, ?> javaConfig) {
        HashMap<String, Object> superstreamConfig = new HashMap<String, Object>();
        Superstream.mapIfPresent(javaConfig, "max.request.size", superstreamConfig, "producer_max_messages_bytes");
        Superstream.mapIfPresent(javaConfig, "acks", superstreamConfig, "producer_required_acks");
        Superstream.mapIfPresent(javaConfig, "delivery.timeout.ms", superstreamConfig, "producer_timeout");
        Superstream.mapIfPresent(javaConfig, "retries", superstreamConfig, "producer_retry_max");
        Superstream.mapIfPresent(javaConfig, "retry.backoff.ms", superstreamConfig, "producer_retry_backoff");
        Superstream.mapIfPresent(javaConfig, "compression.type", superstreamConfig, "producer_compression_level");
        Superstream.mapIfPresent(javaConfig, "fetch.min.bytes", superstreamConfig, "consumer_fetch_min");
        Superstream.mapIfPresent(javaConfig, "fetch.max.bytes", superstreamConfig, "consumer_fetch_default");
        Superstream.mapIfPresent(javaConfig, "retry.backoff.ms", superstreamConfig, "consumer_retry_backoff");
        Superstream.mapIfPresent(javaConfig, "max.poll.interval.ms", superstreamConfig, "consumer_max_wait_time");
        Superstream.mapIfPresent(javaConfig, "max.poll.records", superstreamConfig, "consumer_max_processing_time");
        Superstream.mapIfPresent(javaConfig, "auto.commit.interval.ms", superstreamConfig, "consumer_offset_auto_commit_interval");
        Superstream.mapIfPresent(javaConfig, "session.timeout.ms", superstreamConfig, "consumer_group_session_timeout");
        Superstream.mapIfPresent(javaConfig, "heartbeat.interval.ms", superstreamConfig, "consumer_group_heart_beat_interval");
        Superstream.mapIfPresent(javaConfig, "retry.backoff.ms", superstreamConfig, "consumer_group_rebalance_retry_back_off");
        Superstream.mapIfPresent(javaConfig, "group.id", superstreamConfig, "consumer_group_id");
        Superstream.mapIfPresent(javaConfig, "bootstrap.servers", superstreamConfig, "servers");
        return superstreamConfig;
    }

    private static void mapIfPresent(Map<String, ?> javaConfig, String javaKey, Map<String, Object> superstreamConfig, String superstreamKey) {
        if (javaConfig.containsKey(javaKey)) {
            if (javaKey == "bootstrap.servers") {
                Object value = javaConfig.get(javaKey);
                if (value instanceof String[]) {
                    superstreamConfig.put(superstreamKey, Arrays.toString((String[])value));
                } else if (value instanceof ArrayList) {
                    ArrayList arrayList = (ArrayList)value;
                    superstreamConfig.put(superstreamKey, String.join((CharSequence)", ", arrayList));
                } else {
                    superstreamConfig.put(superstreamKey, value);
                }
            } else {
                superstreamConfig.put(superstreamKey, javaConfig.get(javaKey));
            }
        }
    }

    public static Map<String, Object> initSuperstreamConfig(Map<String, Object> configs, String type) {
        String isInnerConsumer = (String)configs.get("superstream.inner.consumer");
        if (isInnerConsumer != null && isInnerConsumer.equals("true")) {
            return configs;
        }
        String interceptors = (String)configs.get("interceptor.classes");
        switch (type) {
            case "producer": {
                interceptors = interceptors != null && !interceptors.isEmpty() ? interceptors + "," + SuperstreamProducerInterceptor.class.getName() : SuperstreamProducerInterceptor.class.getName();
                if (!configs.containsKey("value.serializer") || configs.containsKey("original.serializer")) break;
                configs.put("original.serializer", configs.get("value.serializer"));
                configs.put("value.serializer", SuperstreamSerializer.class.getName());
                break;
            }
            case "consumer": {
                interceptors = interceptors != null && !interceptors.isEmpty() ? interceptors + "," + SuperstreamConsumerInterceptor.class.getName() : SuperstreamConsumerInterceptor.class.getName();
                if (!configs.containsKey("value.deserializer") || configs.containsKey("original.deserializer")) break;
                configs.put("original.deserializer", configs.get("value.deserializer"));
                configs.put("value.deserializer", SuperstreamDeserializer.class.getName());
            }
        }
        if (interceptors != null) {
            configs.put("interceptor.classes", interceptors);
        }
        try {
            Map<String, String> envVars = System.getenv();
            String superstreamHost = envVars.get("SUPERSTREAM_HOST");
            if (superstreamHost == null) {
                throw new Exception("host is required");
            }
            configs.put("superstream.host", superstreamHost);
            String token = envVars.get("SUPERSTREAM_TOKEN");
            if (token == null) {
                token = "no-auth";
            }
            configs.put("superstream.token", token);
            String learningFactorString = envVars.get("SUPERSTREAM_LEARNING_FACTOR");
            Integer learningFactor = Consts.superstreamDefaultLearningFactor;
            if (learningFactorString != null) {
                learningFactor = Integer.parseInt(learningFactorString);
            }
            configs.put("superstream.learning.factor", learningFactor);
            Boolean reductionEnabled = false;
            String reductionEnabledString = envVars.get("SUPERSTREAM_REDUCTION_ENABLED");
            if (reductionEnabledString != null) {
                reductionEnabled = Boolean.parseBoolean(reductionEnabledString);
            }
            configs.put("superstream.reduction.enabled", reductionEnabled);
            Superstream superstreamConnection = new Superstream(token, superstreamHost, learningFactor, configs, reductionEnabled, type);
            superstreamConnection.init();
            configs.put("superstream.connection", superstreamConnection);
        }
        catch (Exception e) {
            String errMsg = String.format("superstream: error initializing superstream: %s", e.getMessage());
            System.out.println(errMsg);
            switch (type) {
                case "producer": {
                    if (!configs.containsKey("original.serializer")) break;
                    configs.put("value.serializer", configs.get("original.serializer"));
                    configs.remove("original.serializer");
                    break;
                }
                case "consumer": {
                    if (!configs.containsKey("original.deserializer")) break;
                    configs.put("value.deserializer", configs.get("original.deserializer"));
                    configs.remove("original.deserializer");
                }
            }
        }
        return configs;
    }

    public static Properties initSuperstreamProps(Properties properties, String type) {
        String interceptors = (String)properties.get("interceptor.classes");
        switch (type) {
            case "producer": {
                interceptors = interceptors != null && !interceptors.isEmpty() ? interceptors + "," + SuperstreamProducerInterceptor.class.getName() : SuperstreamProducerInterceptor.class.getName();
                if (!properties.containsKey("value.serializer") || properties.containsKey("original.serializer")) break;
                properties.put("original.serializer", properties.get("value.serializer"));
                properties.put("value.serializer", SuperstreamSerializer.class.getName());
                break;
            }
            case "consumer": {
                interceptors = interceptors != null && !interceptors.isEmpty() ? interceptors + "," + SuperstreamConsumerInterceptor.class.getName() : SuperstreamConsumerInterceptor.class.getName();
                if (!properties.containsKey("value.deserializer") || properties.containsKey("original.deserializer")) break;
                properties.put("original.deserializer", properties.get("value.deserializer"));
                properties.put("value.deserializer", SuperstreamDeserializer.class.getName());
            }
        }
        if (interceptors != null) {
            properties.put("interceptor.classes", interceptors);
        }
        try {
            Map<String, String> envVars = System.getenv();
            String superstreamHost = envVars.get("SUPERSTREAM_HOST");
            if (superstreamHost == null) {
                throw new Exception("host is required");
            }
            properties.put("superstream.host", superstreamHost);
            String token = envVars.get("SUPERSTREAM_TOKEN");
            if (token == null) {
                token = "no-auth";
            }
            properties.put("superstream.token", token);
            String learningFactorString = envVars.get("SUPERSTREAM_LEARNING_FACTOR");
            Integer learningFactor = Consts.superstreamDefaultLearningFactor;
            if (learningFactorString != null) {
                learningFactor = Integer.parseInt(learningFactorString);
            }
            properties.put("superstream.learning.factor", learningFactor);
            Boolean reductionEnabled = false;
            String reductionEnabledString = envVars.get("SUPERSTREAM_REDUCTION_ENABLED");
            if (reductionEnabledString != null) {
                reductionEnabled = Boolean.parseBoolean(reductionEnabledString);
            }
            properties.put("superstream.reduction.enabled", reductionEnabled);
            Map<String, Object> configs = Superstream.propertiesToMap(properties);
            Superstream superstreamConnection = new Superstream(token, superstreamHost, learningFactor, configs, reductionEnabled, type);
            superstreamConnection.init();
            properties.put("superstream.connection", superstreamConnection);
        }
        catch (Exception e) {
            String errMsg = String.format("superstream: error initializing superstream: %s", e.getMessage());
            System.out.println(errMsg);
        }
        return properties;
    }

    public static Map<String, Object> propertiesToMap(Properties properties) {
        return properties.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> e.getValue()));
    }

    public void updateTopicPartitions(String topic, Integer partition) {
        Set partitions = this.topicPartitions.computeIfAbsent(topic, k -> new HashSet());
        if (!partitions.contains(partition)) {
            partitions.add(partition);
        }
    }
}

