/*
 * Decompiled with CFR 0.152.
 */
package swim.spatial;

import java.util.NoSuchElementException;
import swim.spatial.BitInterval;
import swim.spatial.QTreeEntry;
import swim.spatial.QTreeNode;
import swim.spatial.QTreePage;
import swim.util.Cursor;

final class QTreeNodeCursor<K, S, V>
implements Cursor<QTreeEntry<K, S, V>> {
    final QTreeNode<K, S, V> page;
    final long x;
    final long y;
    long index;
    int slotIndex;
    int pageIndex;
    Cursor<QTreeEntry<K, S, V>> pageCursor;

    QTreeNodeCursor(QTreeNode<K, S, V> page, long x, long y, long index, int slotIndex, int pageIndex) {
        this.page = page;
        this.x = x;
        this.y = y;
        this.index = index;
        this.slotIndex = slotIndex;
        this.pageIndex = pageIndex;
    }

    QTreeNodeCursor(QTreeNode<K, S, V> page, long x, long y) {
        this(page, x, y, 0L, 0, 0);
    }

    Cursor<QTreeEntry<K, S, V>> pageCursor(QTreePage<K, S, V> page) {
        return page.cursor(this.x, this.y);
    }

    public boolean isEmpty() {
        long x = this.x;
        long y = this.y;
        QTreeEntry<K, S, V>[] slots = this.page.slots;
        while (this.slotIndex < slots.length) {
            QTreeEntry slot = slots[this.slotIndex];
            if (!BitInterval.intersects(x, y, slot.x, slot.y)) continue;
            return false;
        }
        while (true) {
            Cursor<QTreeEntry<K, S, V>> pageCursor;
            if ((pageCursor = this.pageCursor) != null) {
                if (!pageCursor.isEmpty()) {
                    return false;
                }
                this.pageCursor = null;
                continue;
            }
            int pageIndex = this.pageIndex;
            QTreePage<K, S, V>[] pages = this.page.pages;
            if (pageIndex >= pages.length) break;
            QTreePage page = pages[pageIndex];
            if (BitInterval.intersects(x, y, page.x(), page.y())) {
                this.pageCursor = this.pageCursor(page);
            } else {
                this.index += page.span();
            }
            this.pageIndex = pageIndex + 1;
        }
        return true;
    }

    public QTreeEntry<K, S, V> head() {
        long x = this.x;
        long y = this.y;
        QTreeEntry<K, S, V>[] slots = this.page.slots;
        while (this.slotIndex < slots.length) {
            QTreeEntry slot = slots[this.slotIndex];
            if (!BitInterval.intersects(x, y, slot.x, slot.y)) continue;
            return slot;
        }
        while (true) {
            Cursor<QTreeEntry<K, S, V>> pageCursor;
            if ((pageCursor = this.pageCursor) != null) {
                if (!pageCursor.isEmpty()) {
                    return (QTreeEntry)pageCursor.head();
                }
                this.pageCursor = null;
                continue;
            }
            int pageIndex = this.pageIndex;
            QTreePage<K, S, V>[] pages = this.page.pages;
            if (pageIndex >= pages.length) break;
            QTreePage page = pages[pageIndex];
            if (BitInterval.intersects(x, y, page.x(), page.y())) {
                this.pageCursor = this.pageCursor(page);
            } else {
                this.index += page.span();
            }
            this.pageIndex = pageIndex + 1;
        }
        throw new NoSuchElementException();
    }

    public void step() {
        long x = this.x;
        long y = this.y;
        QTreeEntry<K, S, V>[] slots = this.page.slots;
        while (this.slotIndex < slots.length) {
            QTreeEntry slot = slots[this.slotIndex];
            ++this.index;
            ++this.slotIndex;
            if (!BitInterval.intersects(x, y, slot.x, slot.y)) continue;
            return;
        }
        while (true) {
            Cursor<QTreeEntry<K, S, V>> pageCursor;
            if ((pageCursor = this.pageCursor) != null) {
                if (pageCursor.hasNext()) {
                    ++this.index;
                    pageCursor.step();
                    continue;
                }
                this.pageCursor = null;
                continue;
            }
            int pageIndex = this.pageIndex;
            QTreePage<K, S, V>[] pages = this.page.pages;
            if (pageIndex >= pages.length) break;
            QTreePage page = pages[pageIndex];
            if (BitInterval.intersects(x, y, page.x(), page.y())) {
                this.pageCursor = this.pageCursor(page);
            } else {
                this.index += page.span();
            }
            this.pageIndex = pageIndex + 1;
        }
        throw new UnsupportedOperationException();
    }

    public void skip(long count) {
        while (count > 0L) {
            Cursor<QTreeEntry<K, S, V>> pageCursor = this.pageCursor;
            if (pageCursor != null) {
                if (pageCursor.hasNext()) {
                    ++this.index;
                    --count;
                    pageCursor.next();
                    continue;
                }
                this.pageCursor = null;
                continue;
            }
            int pageIndex = this.pageIndex;
            QTreePage<K, S, V>[] pages = this.page.pages;
            if (pageIndex >= pages.length) break;
            QTreePage page = pages[pageIndex];
            long pageSpan = page.span();
            this.pageIndex = pageIndex + 1;
            if (pageSpan < count) {
                this.pageCursor = this.pageCursor(page);
                if (count <= 0L) break;
                this.index += count;
                this.pageCursor.skip(count);
                count = 0L;
                break;
            }
            this.index += pageSpan;
            count -= pageSpan;
        }
    }

    public boolean hasNext() {
        long x = this.x;
        long y = this.y;
        QTreeEntry<K, S, V>[] slots = this.page.slots;
        while (this.slotIndex < slots.length) {
            QTreeEntry slot = slots[this.slotIndex];
            if (BitInterval.intersects(x, y, slot.x, slot.y)) {
                return true;
            }
            ++this.index;
            ++this.slotIndex;
        }
        while (true) {
            Cursor<QTreeEntry<K, S, V>> pageCursor;
            if ((pageCursor = this.pageCursor) != null) {
                if (pageCursor.hasNext()) {
                    return true;
                }
                this.pageCursor = null;
                continue;
            }
            int pageIndex = this.pageIndex;
            QTreePage<K, S, V>[] pages = this.page.pages;
            if (pageIndex >= pages.length) break;
            QTreePage page = pages[pageIndex];
            if (BitInterval.intersects(x, y, page.x(), page.y())) {
                this.pageCursor = this.pageCursor(page);
            } else {
                this.index += page.span();
            }
            this.pageIndex = pageIndex + 1;
        }
        return false;
    }

    public long nextIndexLong() {
        return this.index;
    }

    public QTreeEntry<K, S, V> next() {
        long x = this.x;
        long y = this.y;
        QTreeEntry<K, S, V>[] slots = this.page.slots;
        while (this.slotIndex < slots.length) {
            QTreeEntry slot = slots[this.slotIndex];
            ++this.index;
            ++this.slotIndex;
            if (!BitInterval.intersects(x, y, slot.x, slot.y)) continue;
            return slot;
        }
        while (true) {
            Cursor<QTreeEntry<K, S, V>> pageCursor;
            if ((pageCursor = this.pageCursor) != null) {
                if (pageCursor.hasNext()) {
                    ++this.index;
                    return (QTreeEntry)pageCursor.next();
                }
                this.pageCursor = null;
                continue;
            }
            int pageIndex = this.pageIndex;
            QTreePage<K, S, V>[] pages = this.page.pages;
            if (pageIndex >= pages.length) break;
            QTreePage page = pages[pageIndex];
            if (BitInterval.intersects(x, y, page.x(), page.y())) {
                this.pageCursor = this.pageCursor(page);
            } else {
                this.index += page.span();
            }
            this.pageIndex = pageIndex + 1;
        }
        throw new NoSuchElementException();
    }

    public boolean hasPrevious() {
        long x = this.x;
        long y = this.y;
        while (true) {
            Cursor<QTreeEntry<K, S, V>> pageCursor;
            if ((pageCursor = this.pageCursor) != null) {
                if (pageCursor.hasPrevious()) {
                    return true;
                }
                this.pageCursor = null;
                continue;
            }
            QTreePage<K, S, V>[] pages = this.page.pages;
            int pageIndex = this.pageIndex - 1;
            if (pageIndex < 0) break;
            QTreePage page = pages[pageIndex];
            if (BitInterval.intersects(x, y, page.x(), page.y())) {
                this.pageCursor = this.pageCursor(page);
            } else {
                this.index -= page.span();
            }
            this.pageIndex = pageIndex;
        }
        QTreeEntry<K, S, V>[] slots = this.page.slots;
        while (this.slotIndex > 0) {
            QTreeEntry slot = slots[this.slotIndex - 1];
            if (BitInterval.intersects(x, y, slot.x, slot.y)) {
                return true;
            }
            --this.index;
            --this.slotIndex;
        }
        return false;
    }

    public long previousIndexLong() {
        return this.index - 1L;
    }

    public QTreeEntry<K, S, V> previous() {
        long x = this.x;
        long y = this.y;
        while (true) {
            Cursor<QTreeEntry<K, S, V>> pageCursor;
            if ((pageCursor = this.pageCursor) != null) {
                if (pageCursor.hasPrevious()) {
                    --this.index;
                    return (QTreeEntry)pageCursor.previous();
                }
                this.pageCursor = null;
                continue;
            }
            int pageIndex = this.pageIndex - 1;
            QTreePage<K, S, V>[] pages = this.page.pages;
            if (pageIndex >= pages.length) break;
            QTreePage page = pages[pageIndex];
            if (BitInterval.intersects(x, y, page.x(), page.y())) {
                this.pageCursor = this.pageCursor(page);
            } else {
                this.index -= page.span();
            }
            this.pageIndex = pageIndex;
        }
        QTreeEntry<K, S, V>[] slots = this.page.slots;
        while (this.slotIndex > 0) {
            QTreeEntry slot = slots[this.slotIndex - 1];
            --this.index;
            --this.slotIndex;
            if (!BitInterval.intersects(x, y, slot.x, slot.y)) continue;
            return slot;
        }
        throw new NoSuchElementException();
    }
}

