/*
 * Decompiled with CFR 0.152.
 */
package swim.spatial;

import swim.math.R2Shape;
import swim.math.R2ToZ2Operator;
import swim.math.Z2Form;
import swim.math.Z2ToR2Operator;
import swim.spatial.GeoProjection;
import swim.structure.Item;

final class SphericalMercator
extends Z2Form<R2Shape>
implements R2ToZ2Operator {
    static final double MAX_LAT = Math.atan(Math.sinh(Math.PI));

    SphericalMercator() {
    }

    public Class<?> type() {
        return R2Shape.class;
    }

    public long getXMin(R2Shape shape) {
        return SphericalMercator.transformLng(shape.xMin());
    }

    public long getYMin(R2Shape shape) {
        return SphericalMercator.transformLat(shape.yMin());
    }

    public long getXMax(R2Shape shape) {
        return SphericalMercator.transformLng(shape.xMax());
    }

    public long getYMax(R2Shape shape) {
        return SphericalMercator.transformLat(shape.yMax());
    }

    public boolean contains(R2Shape outer, R2Shape inner) {
        return outer.contains(inner);
    }

    public boolean intersects(R2Shape s, R2Shape t) {
        return s.intersects(t);
    }

    public Item mold(R2Shape shape) {
        return R2Shape.shapeForm().mold((Object)shape);
    }

    public R2Shape cast(Item item) {
        return (R2Shape)R2Shape.shapeForm().cast(item);
    }

    public long transformX(double lng, double lat) {
        return SphericalMercator.transformLng(lng);
    }

    public long transformY(double lng, double lat) {
        return SphericalMercator.transformLat(lat);
    }

    public Z2ToR2Operator inverse() {
        return GeoProjection.sphericalMercatorInverse();
    }

    static long transformLng(double lng) {
        return SphericalMercator.scale(Math.toRadians(lng));
    }

    static long transformLat(double lat) {
        return SphericalMercator.scale(Math.log(Math.tan(0.7853981633974483 + Math.min(Math.max(-MAX_LAT, Math.toRadians(lat)), MAX_LAT) / 2.0)));
    }

    static long scale(double x) {
        return (long)((Math.min(Math.max(-Math.PI, x), Math.PI) + Math.PI) / (Math.PI * 2) * 9.223372036854776E18);
    }
}

